/*
 * Decompiled with CFR 0.152.
 */
package com.snowMirror.upgrade;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keystore {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Path rootDir;

    public Keystore(Path rootDir) {
        this.rootDir = rootDir;
    }

    public void importTrustedCertificates() {
        this.importJksToCacerts(this.rootDir.resolve("snow-mirror").resolve("trusted-certificates").resolve("trusted-certificates"));
    }

    public void importSnowMirrorJksToCacerts() {
        this.importJksToCacerts(this.rootDir.resolve("snowMirror.jks"));
    }

    private void importJksToCacerts(Path jksToImport) {
        Path keyToolPath = this.rootDir.resolve("jre").resolve("bin").resolve("keytool.exe");
        if (!Files.exists(keyToolPath, new LinkOption[0])) {
            keyToolPath = this.rootDir.resolve("jre").resolve("bin").resolve("keytool");
        }
        if (!Files.exists(keyToolPath, new LinkOption[0])) {
            this.logger.info("Failed to import certificate to JKS. Keytool not found: {}", (Object)keyToolPath);
            return;
        }
        try {
            this.logger.info("Importing {} to cacerts.", (Object)jksToImport.getFileName());
            Path cacerts = this.rootDir.resolve("jre/lib/security/cacerts");
            if (!Files.exists(jksToImport, new LinkOption[0])) {
                this.logger.info("Finished. (nothing to do, {} does not exist)", (Object)jksToImport);
                return;
            }
            List<String> commands = List.of(keyToolPath.toAbsolutePath().toString(), "-importkeystore", "-srckeystore", jksToImport.toString(), "-destkeystore", cacerts.toString(), "-storepass", "changeit", "-srcstorepass", "changeit", "-noprompt");
            this.logger.info("Command: {}", (Object)String.join((CharSequence)" ", commands));
            ProcessBuilder ps = new ProcessBuilder(commands);
            ps.redirectErrorStream(true);
            Process pr = ps.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    this.logger.info("{}", (Object)line);
                }
                pr.waitFor();
            }
            this.logger.info("Finished.");
        }
        catch (Exception e) {
            this.logger.warn("Failure.", e);
        }
    }
}

