#!/bin/sh

script_path=`dirname $0`
snowmirror_dir=$script_path/..
setenv_dir=`pwd`
cd $snowmirror_dir
snowmirror_dir=`pwd`
snowmirror_dir_name=`basename $snowmirror_dir`
cd $setenv_dir

snowmirror_jre_dir=$snowmirror_dir/jre
echo "SnowMirror JRE dir: $snowmirror_jre_dir"

if [ -d "$snowmirror_jre_dir" ]; then
	echo "Directory with JRE found inside SnowMirror directory."
	echo "Using this JRE to run SnowMirror."
	echo "Setting JRE_HOME to $snowmirror_jre_dir"
	JRE_HOME=$snowmirror_jre_dir
fi

snowmirror_pid_file_name="snowmirror-$snowmirror_dir_name.pid"
if [ -d "/run" ] && [ -w "/run" ]; then
	CATALINA_PID="/run/$snowmirror_pid_file_name"
elif [ -d "/var/run" ] && [ -w "/var/run" ]; then
	CATALINA_PID="/var/run/$snowmirror_pid_file_name"
elif [ -d "$snowmirror_dir/bin" ] && [ -w "$snowmirror_dir/bin" ]; then
	CATALINA_PID="$snowmirror_dir/bin/$snowmirror_pid_file_name"
fi

if [ -z $CATALINA_PID ]; then
	echo "Not setting \$CATALINA_PID"
else
	echo "Setting \$CATALINA_PID to $CATALINA_PID"
fi

# Set additional classpath
DRIVER_CLASSPATH="${DRIVER_CLASSPATH#:}"
DRIVER_CLASSPATH="${DRIVER_CLASSPATH%:}"
ADDITIONAL_CLASSPATH="${ADDITIONAL_CLASSPATH#:}"
ADDITIONAL_CLASSPATH="${ADDITIONAL_CLASSPATH%:}"
CLASSPATH="${DRIVER_CLASSPATH}:${ADDITIONAL_CLASSPATH}"
CLASSPATH=${CLASSPATH#:}
CLASSPATH=${CLASSPATH%:}
echo "Classpath: $CLASSPATH"