@echo off
REM	Startup script for SnowMirror standalone distribution

if "%OS%"=="Windows_NT" goto begin
echo Unsupported Windows version: %OS%
pause
goto :eof

:begin
set "CURRENT_DIR=%cd%"
set APP_PROFILE=live
set APP_CONFFILE=%CURRENT_DIR%\snowMirror.properties

:checkCurrentDir
rem Check if user is in root installer directory
if exist "%CURRENT_DIR%\bin\startup.bat" goto init
echo The 'CURRENT_DIR' variable must be set to root standalone installer folder, or the script must be executed from that folder.
goto end

:init
REM Parse Application port number
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.port" "%APP_CONFFILE%"') do set "APP_PORT=%%a"
set "APP_PORT=%APP_PORT: =%"
IF ["%APP_PORT%"] EQU ["="] SET APP_PORT=""
IF ["%APP_PORT%"] EQU [" = "] SET APP_PORT=""
IF ["%APP_PORT%"] EQU ["= "] SET APP_PORT=""
IF ["%APP_PORT%"] EQU [" ="] SET APP_PORT=""

REM Parse Control port number
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.controlport" "%APP_CONFFILE%"') do set "CONTROL_PORT=%%a"
set "CONTROL_PORT=%CONTROL_PORT: =%"
IF ["%CONTROL_PORT%"] EQU ["="] SET CONTROL_PORT=""
IF ["%CONTROL_PORT%"] EQU [" = "] SET CONTROL_PORT=""
IF ["%CONTROL_PORT%"] EQU ["= "] SET CONTROL_PORT=""
IF ["%CONTROL_PORT%"] EQU [" ="] SET CONTROL_PORT=""

REM Parse Application context
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.context" "%APP_CONFFILE%"') do set "APP_CONTEXT=%%a"
set "APP_CONTEXT=%APP_CONTEXT: =%"
IF ["%APP_CONTEXT%"] EQU ["="] SET APP_CONTEXT=""
IF ["%APP_CONTEXT%"] EQU [" = "] SET APP_CONTEXT=""
IF ["%APP_CONTEXT%"] EQU ["= "] SET APP_CONTEXT=""
IF ["%APP_CONTEXT%"] EQU [" ="] SET APP_CONTEXT=""

REM Parse Xms
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.memory.Xms" "%APP_CONFFILE%"') do set "APP_XMS=%%a"
set "APP_XMS=%APP_XMS: =%"
IF ["%APP_XMS%"] EQU ["="] SET APP_XMS=""
IF ["%APP_XMS%"] EQU [" = "] SET APP_XMS=""
IF ["%APP_XMS%"] EQU ["= "] SET APP_XMS=""
IF ["%APP_XMS%"] EQU [" ="] SET APP_XMS=""

REM Parse Xmx
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.memory.Xmx" "%APP_CONFFILE%"') do set "APP_XMX=%%a"
set "APP_XMX=%APP_XMX: =%"
IF ["%APP_XMX%"] EQU ["="] SET APP_XMX=""
IF ["%APP_XMX%"] EQU [" = "] SET APP_XMX=""
IF ["%APP_XMX%"] EQU ["= "] SET APP_XMX=""
IF ["%APP_XMX%"] EQU [" ="] SET APP_XMX=""

REM Parse JAVA_OPTS
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.startup.java_opts" "%APP_CONFFILE%"') do set "APP_JAVA_OPTS=%%a"
set "APP_JAVA_OPTS=%APP_JAVA_OPTS: =%"
IF ["%APP_JAVA_OPTS%"] EQU ["="] SET APP_JAVA_OPTS=""
IF ["%APP_JAVA_OPTS%"] EQU [" = "] SET APP_JAVA_OPTS=""
IF ["%APP_JAVA_OPTS%"] EQU ["= "] SET APP_JAVA_OPTS=""
IF ["%APP_JAVA_OPTS%"] EQU [" ="] SET APP_JAVA_OPTS=""

REM Parse APP_CATALINA_OPTS
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.startup.catalina_opts" "%APP_CONFFILE%"') do set "APP_CATALINA_OPTS=%%a"
set "APP_CATALINA_OPTS=%APP_CATALINA_OPTS: =%"
IF ["%APP_CATALINA_OPTS%"] EQU ["="] SET APP_CATALINA_OPTS=""
IF ["%APP_CATALINA_OPTS%"] EQU [" = "] SET APP_CATALINA_OPTS=""
IF ["%APP_CATALINA_OPTS%"] EQU ["= "] SET APP_CATALINA_OPTS=""
IF ["%APP_CATALINA_OPTS%"] EQU [" ="] SET APP_CATALINA_OPTS=""

@echo "Memory settings in %APP_CONFFILE%: Xms=%APP_XMS%, Xmx=%APP_XMX%"
@echo "JAVA_OPTS in %APP_CONFFILE%:       %APP_JAVA_OPTS%"
@echo "CATALINA_OPTS in %APP_CONFFILE%:   %APP_CATALINA_OPTS%"

IF [%APP_XMS%] EQU [""] SET APP_XMS="700m"
IF [%APP_XMX%] EQU [""] SET APP_XMX="2G"

:run
@echo ### Starting server on http://localhost:%APP_PORT%%APP_CONTEXT% ###
@echo Memory settings: Xms=%APP_XMS%, Xmx=%APP_XMX%

REM Set JAVA_OPTS passed to server by catalina.bat
set JAVA_OPTS=-Duser.timezone=UTC -Duser.country=en -Duser.language=en -DsnowMirror.logDir="%CURRENT_DIR%\logs" -DsnowMirror.dataDir="file:///%CURRENT_DIR%\snow-mirror\data" -DsnowMirror.properties.location="file:///%CURRENT_DIR%\snow-mirror\conf\\" -DsnowMirror.config.db.location="file:///%CURRENT_DIR%\snowMirror.properties" -DsnowMirror.config.location="file:///%CURRENT_DIR%\snow-mirror\conf\\" -DsnowMirror.themesDir="file:///%CURRENT_DIR%\snow-mirror-themes\\" -Dspring.profiles.active=%APP_PROFILE% -Dtomcat.http.port=%APP_PORT% -Dtomcat.http.controlport=%CONTROL_PORT% -Dtomcat.snowMirror.context=%APP_CONTEXT%
if [%APP_JAVA_OPTS%] NEQ [""] set "JAVA_OPTS=%JAVA_OPTS% %APP_JAVA_OPTS%"

set "CATALINA_OPTS=-Xms%APP_XMS% -Xmx%APP_XMX%"
if [%APP_CATALINA_OPTS%] NEQ [""] set "CATALINA_OPTS=%CATALINA_OPTS% %APP_CATALINA_OPTS%"

set "EXECUTABLE=%CURRENT_DIR%\bin\startup.bat"
rem Check that target executable exists
if exist "%EXECUTABLE%" goto okExec
echo Cannot find "%EXECUTABLE%"
echo This file is needed to run this program
goto end
:okExec
rem Get remaining unshifted command line arguments and save them in the
set CMD_LINE_ARGS=
:setArgs
if ""%1""=="""" goto doneSetArgs
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto setArgs
:doneSetArgs

call "%EXECUTABLE%" %CMD_LINE_ARGS%

:end

:finish
pause
cmd /C exit /B %ERRORLEVEL%
