ALTER VIEW [${schema}].[synchronizationView] AS (
SELECT sync.id,
  sync.manual,
  sync.waiting,
  sync.enabled,
  sync.name,
  (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) as nextIncrementalStartLong,
  (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) as nextFullStartLong,
  (CASE
   WHEN
     (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) is null
     OR
     (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) is null
   THEN
     COALESCE(
         (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END),
         (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
     )
   ELSE
     (CASE
      WHEN
        (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END)
        <
        (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
      THEN
        (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END)
      ELSE
        (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
      END
     )
   END
  ) as nextStartLong,
  a.id AS lastLog_id,
  DATEDIFF(SECOND, a.startDate, a.endDate) * 1000 AS lastDuration
FROM [${schema}].[synchronization] sync
  JOIN [${schema}].[scheduler] incrementalScheduler ON sync.inc_scheduler_id = incrementalScheduler.id
  LEFT JOIN [${schema}].[scheduler] fullScheduler ON sync.full_scheduler_id = fullScheduler.id
  LEFT JOIN [${schema}].QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and 'SyncId_'+ CAST(sync.id AS VARCHAR(50)) = qrtz_incremental.TRIGGER_NAME and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
  LEFT JOIN [${schema}].QRTZ_TRIGGERS qrtz_full ON qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and 'CleanAndSync_SyncId_' + CAST(sync.id AS VARCHAR(50)) = qrtz_full.TRIGGER_NAME and qrtz_full.TRIGGER_GROUP = 'DEFAULT',
  [${schema}].[activityLog] a
WHERE
-- join the latest activity log.
  sync.id = a.synchronization AND a.id in (select max(al.id) as maxid from [${schema}].[activityLog] al group by al.synchronization)
)
UNION
(
-- select synchronizations which have no activity log
SELECT sync.id,
sync.manual,
sync.waiting,
sync.enabled,
sync.name,
(CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) as nextIncrementalStartLong,
(CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) as nextFullStartLong,
  (CASE
   WHEN
     (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) is null
     OR
     (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) is null
   THEN
     COALESCE(
         (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END),
         (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
     )
   ELSE
     (CASE
      WHEN
        (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END)
        <
        (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
      THEN
        (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END)
      ELSE
        (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
      END
     )
   END
  ) as nextStartLong,
  null AS lastLog_id,
  null AS lastDuration
FROM [${schema}].[synchronization] sync
JOIN [${schema}].[scheduler] incrementalScheduler ON sync.inc_scheduler_id = incrementalScheduler.id
LEFT JOIN [${schema}].[scheduler] fullScheduler ON sync.full_scheduler_id = fullScheduler.id
LEFT JOIN [${schema}].QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and 'SyncId_'+ CAST(sync.id AS VARCHAR(50)) = qrtz_incremental.TRIGGER_NAME and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
LEFT JOIN [${schema}].QRTZ_TRIGGERS qrtz_full ON qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and 'CleanAndSync_SyncId_' + CAST(sync.id AS VARCHAR(50)) = qrtz_full.TRIGGER_NAME and qrtz_full.TRIGGER_GROUP = 'DEFAULT'
WHERE
not exists (SELECT al.id FROM [${schema}].[activityLog] al WHERE al.synchronization = sync.id)
)