CREATE TABLE choiceValue (
    `id` bigint NOT NULL,
    `choiceValue` varchar(255) default NULL,
    `label` varchar(255) default NULL,
    `sequence` int default NULL,
    `column_id` bigint NOT NULL,
    PRIMARY KEY (`id`),
    CONSTRAINT `fk_choiceValue_column`
        FOREIGN KEY (`column_id`)
            REFERENCES `snowColumn`(`id`)
            ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

ALTER TABLE `snowColumn` ADD COLUMN `columnLabel` VARCHAR(255) DEFAULT NULL;
ALTER TABLE `snowColumn` ADD COLUMN `reference` VARCHAR(255) DEFAULT NULL;
ALTER TABLE `snowColumn` ADD COLUMN `choice` int DEFAULT NULL;
ALTER TABLE `snowColumn` ADD COLUMN `isFormTitleColumn` TINYINT DEFAULT FALSE;
ALTER TABLE `snowColumn` ADD COLUMN `dvType` VARCHAR(255) DEFAULT NULL;
ALTER TABLE `snowColumn` ADD COLUMN `dvLength` int DEFAULT NULL;
ALTER TABLE `snowColumn` ADD COLUMN `dvIsArrayType` TINYINT DEFAULT NULL;

CREATE TABLE formElement (
    `id` bigint NOT NULL,
    `columnName` varchar(255) default NULL,
    `position` int default NULL,
    `internalType` varchar(255) default NULL,
    `maxLength` int default NULL,
    `type` varchar(20) NOT NULL,
    `createdAt` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `synchronization_id` BIGINT NOT NULL,
    PRIMARY KEY (`id`),
    CONSTRAINT `fk_formElement_synchronization`
        FOREIGN KEY (`synchronization_id`)
        REFERENCES `synchronization`(`id`)
        ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;