DROP VIEW `activityLogView`;
CREATE VIEW `activityLogView` AS
  SELECT
      `al`.`id`
    , `al`.`synchronization`
    , `al`.`type`
    , `al`.`startedBy`
    , `al`.`scheduledStart`
    , `al`.`startDate`
    , `al`.`endDate`
    , `al`.`status`
    , `al`.`migrationStatus`
    , `al`.`insertedCount`
    , `al`.`updatedCount`
    , `al`.`deletedCount`
    , `al`.`totalToInsert`
    , `al`.`totalToUpdate`
    , `al`.`totalToDelete`
    , (`al`.`insertedCount` + `al`.`updatedCount` + `al`.`deletedCount`) AS `total`
    , `al`.`recordsCounted`
    , `al`.`totalKeysForDiff`
    , `al`.`keysForDiffDownloaded`
    , (timestampdiff(SECOND,`al`.`startDate`,`al`.`endDate`) * 1000) AS `duration`
    , st.`type` as snowtableType
  FROM
    `activityLog` `al`
    JOIN `synchronization` sync ON `al`.`synchronization` = `sync`.`id`
    JOIN snowTable st ON sync.snowtable_id = st.id
