CREATE OR REPLACE VIEW synchronizationView AS
  (
    SELECT
      sync.id,
      sync.manual,
      sync.waiting,
      sync.enabled,
      sync.name,
      (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                 qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
       ELSE qrtz_incremental.NEXT_FIRE_TIME END)                                  AS nextIncrementalStartLong,
      (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
       ELSE qrtz_full.NEXT_FIRE_TIME END)                                         AS nextFullStartLong,
      (CASE
       WHEN
         (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                    qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
          ELSE qrtz_incremental.NEXT_FIRE_TIME END) IS NULL
         OR
         (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
          ELSE qrtz_full.NEXT_FIRE_TIME END) IS NULL
       THEN
         COALESCE(
             (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                        qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_incremental.NEXT_FIRE_TIME END),
             (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_full.NEXT_FIRE_TIME END)
         )
       ELSE
         LEAST(
             (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                        qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_incremental.NEXT_FIRE_TIME END),
             (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_full.NEXT_FIRE_TIME END)
         )
       END
      ) AS nextStartLong,
      a.id AS lastLog_id,
      (CAST(a.endDate AS DATE) - CAST(a.startDate AS DATE)) * 24 * 60 * 60 * 1000 AS lastDuration
    FROM synchronization sync
      JOIN scheduler incrementalScheduler ON sync.inc_scheduler_id = incrementalScheduler.id
      LEFT JOIN scheduler fullScheduler ON sync.full_scheduler_id = fullScheduler.id
      LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME =
                                                  'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' AND
                                                  'SyncId_' || sync.ID = qrtz_incremental.TRIGGER_NAME AND
                                                  qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
      LEFT JOIN (SELECT
                   startDate,
                   endDate,
                   synchronization,
                   id
                 FROM activityLog
                 WHERE id IN (SELECT MAX(id)
                              FROM activitylog
                              GROUP BY synchronization)) a
        ON sync.id = a.synchronization
      LEFT JOIN QRTZ_TRIGGERS qrtz_full ON qrtz_full.SCHED_NAME =
                                           'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' AND
                                           'CleanAndSync_SyncId_' || sync.id = qrtz_full.TRIGGER_NAME AND
                                           qrtz_full.TRIGGER_GROUP = 'DEFAULT'
  )  UNION
  (
    SELECT
      sync.id,
      sync.manual,
      sync.waiting,
      sync.enabled,
      sync.name,
      (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                 qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
       ELSE qrtz_incremental.NEXT_FIRE_TIME END)                                  AS nextIncrementalStartLong,
      (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
       ELSE qrtz_full.NEXT_FIRE_TIME END)                                         AS nextFullStartLong,
      (CASE
       WHEN
         (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                    qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
          ELSE qrtz_incremental.NEXT_FIRE_TIME END) IS NULL
         OR
         (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
          ELSE qrtz_full.NEXT_FIRE_TIME END) IS NULL
       THEN
         COALESCE(
             (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                        qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_incremental.NEXT_FIRE_TIME END),
             (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_full.NEXT_FIRE_TIME END)
         )
       ELSE
         LEAST(
             (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR
                        qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_incremental.NEXT_FIRE_TIME END),
             (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL
              ELSE qrtz_full.NEXT_FIRE_TIME END)
         )
       END
      ) AS nextStartLong,
      null AS lastLog_id,
      null AS lastDuration

    FROM synchronization sync
      JOIN scheduler incrementalScheduler ON sync.inc_scheduler_id = incrementalScheduler.id
      LEFT JOIN scheduler fullScheduler ON sync.full_scheduler_id = fullScheduler.id
      LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' AND
                                                  'SyncId_' || sync.ID = qrtz_incremental.TRIGGER_NAME AND
                                                  qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
      LEFT JOIN QRTZ_TRIGGERS qrtz_full ON qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' AND
                                           'CleanAndSync_SyncId_' || sync.id = qrtz_full.TRIGGER_NAME AND
                                           qrtz_full.TRIGGER_GROUP = 'DEFAULT'

    WHERE
    not exists (SELECT al.id FROM activityLog al WHERE al.SYNCHRONIZATION = sync.id)
  )
;

commit;