CREATE TABLE "${schema}".asyncNotification (
  id bigint NOT NULL,
  asyncName character varying(255) NOT NULL,
  subName character varying(255) default NULL,
  description text default NULL,
  status varchar(100) NOT NULL,
  totalCount integer NOT NULL default 0,
  totalDone integer NOT NULL default 0
);

ALTER TABLE ONLY "${schema}".asyncNotification ADD CONSTRAINT asyncNotification_pkey PRIMARY KEY (id);
ALTER TABLE ONLY "${schema}".asyncNotification ADD CONSTRAINT asyncNotification_unique UNIQUE (asyncName);


CREATE TABLE "${schema}".asyncNotificationMessage (
  id bigint NOT NULL,
  notificationId bigint NOT NULL,
  type character varying(255) NOT NULL,
  message text NOT NULL,
  createTime timestamp without time zone NOT NULL
);

ALTER TABLE ONLY "${schema}".asyncNotificationMessage ADD CONSTRAINT asyncNotificationMsg_pkey PRIMARY KEY (id);
ALTER TABLE ONLY "${schema}".asyncNotificationMessage ADD CONSTRAINT fk_msg_notificationId FOREIGN KEY(notificationId) REFERENCES "${schema}".asyncNotification(id);
