/*
 * Decompiled with CFR 0.152.
 */
package com.snowMirror.upgrade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerXml {
    private final Path path;
    private final Path sslConfigJsonPath;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ServerXml(Path path, Path sslConfigJsonPath) {
        this.path = path;
        this.sslConfigJsonPath = sslConfigJsonPath;
    }

    public void upgrade() {
        try {
            this.logger.info("Updating server.xml.");
            String content = Files.readString(this.path, StandardCharsets.UTF_8);
            String newContent = this.commentJasperListener(content);
            newContent = this.addErrorReportValve(newContent);
            newContent = this.upgradeHttpsToTomcat10(newContent);
            newContent = this.upgradeSslConfiguration(newContent, this.sslConfigJsonPath);
            newContent = this.addRemoteIpValve(newContent);
            if (!Objects.equals(content, newContent)) {
                Files.writeString(this.path, (CharSequence)newContent, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            this.logger.info("Finished updating server.xml.");
        }
        catch (Exception e) {
            this.logger.warn("Failed to upgrade server.xml", e);
        }
    }

    public String addErrorReportValve(String content) {
        this.logger.info("Adding ErrorReportValve");
        if (content.contains("ErrorReportValve")) {
            this.logger.info("Finished. ErrorReportValve already present.");
            return content;
        }
        String newContent = content.replaceFirst("</Host>", "<Valve className=\"org.apache.catalina.valves.ErrorReportValve\" showReport=\"false\" showServerInfo=\"false\" errorCode.404=\"webapps/snowMirror/WEB-INF/pages/404.html\"/></Host>");
        this.logger.info("Finished.");
        return newContent;
    }

    public String commentJasperListener(String content) {
        this.logger.info("Commenting out JasperListener.");
        String jasperListener = "<Listener className=\"org.apache.catalina.core.JasperListener\" />";
        String jasperListenerCommented = "<!--Listener className=\"org.apache.catalina.core.JasperListener\" /-->";
        String newContent = content.replaceFirst(jasperListener, jasperListenerCommented);
        if (Objects.equals(content, newContent)) {
            this.logger.info("Finished. Nothing to do - JasperListener not present or already commented out.");
        } else {
            this.logger.info("Finished.");
        }
        return newContent;
    }

    public String upgradeHttpsToTomcat10(String content) {
        Pattern connectorMatcher = Pattern.compile("(.*<Connector[^>]+https[^>]+)(\"\\s*)(/>)(.*)", 32);
        Matcher matcher = connectorMatcher.matcher(content);
        if (!matcher.matches()) {
            return content;
        }
        String sslEnabledProtocolsValue = this.extractParameter("sslEnabledProtocols", content);
        String keystoreFileValue = this.extractParameter("keystoreFile", content);
        String keystorePassValue = this.extractParameter("keystorePass", content);
        String newContent = content;
        newContent = this.removeParam("clientAuth", newContent);
        newContent = this.removeParam("sslProtocol", newContent);
        newContent = this.removeParam("sslEnabledProtocols", newContent);
        newContent = this.removeParam("keystoreFile", newContent);
        newContent = this.removeParam("keystorePass", newContent);
        matcher = connectorMatcher.matcher(newContent);
        while (matcher.find()) {
            Object replacement = "\">\n\n";
            replacement = (String)replacement + "                <SSLHostConfig hostname=\"_default_\" sslProtocol=\"TLS\" protocols=\"" + this.sanitizeReplacement(sslEnabledProtocolsValue) + "\">\n";
            replacement = (String)replacement + "                        <Certificate certificateKeystoreFile=\"" + this.sanitizeReplacement(keystoreFileValue) + "\" certificateKeystorePassword=\"" + this.sanitizeReplacement(keystorePassValue) + "\"/>\n";
            replacement = (String)replacement + "                </SSLHostConfig>\n\n\n";
            replacement = (String)replacement + "        </Connector>";
            newContent = matcher.replaceFirst("$1" + (String)replacement + " $4");
        }
        return newContent;
    }

    public String upgradeSslConfiguration(String content, Path sslConfigJsonPath) throws IOException {
        JsonNode sslConfigJson;
        this.logger.info("Updating SSL protocols and ciphers");
        String newContent = content;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            sslConfigJson = objectMapper.readTree(sslConfigJsonPath.toFile());
        }
        catch (Exception e) {
            this.logger.warn("Failed to update TLS protocols and ciphers!", e);
            return newContent;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put(this.extractParameter("protocols", newContent), sslConfigJson.get("sslProtocols").asText());
        placeholders.put(this.extractParameter("ciphers", newContent), sslConfigJson.get("ciphers").asText());
        for (Map.Entry entry : placeholders.entrySet()) {
            if (entry.getKey() == null || "".equals(entry.getValue()) || ((String)entry.getKey()).isEmpty() || ((String)entry.getKey()).isBlank()) continue;
            newContent = newContent.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return newContent;
    }

    public String addRemoteIpValve(String content) {
        this.logger.info("Adding RemoteIpValve.");
        if (content == null || content.contains("org.apache.catalina.valves.RemoteIpValve")) {
            return content;
        }
        int idx = content.indexOf("<Valve className=\"org.apache.catalina.valves.AccessLogValve\"");
        if (idx < 0) {
            this.logger.info("Not adding RemoteIpValve. Failed to find a position where to add it.");
            return content;
        }
        Object contentWithRemoteIpValve = content.substring(0, idx);
        int newLineIdx = ((String)contentWithRemoteIpValve).lastIndexOf("\r\n", idx);
        contentWithRemoteIpValve = (String)contentWithRemoteIpValve + "<Valve className=\"org.apache.catalina.valves.RemoteIpValve\" hostHeader=\"X-Forwarded-Host\" portHeader=\"X-Forwarded-Port\"/>";
        contentWithRemoteIpValve = (String)contentWithRemoteIpValve + "\r\n\r\n";
        contentWithRemoteIpValve = (String)contentWithRemoteIpValve + " ".repeat(idx - newLineIdx - 2) + content.substring(idx);
        return contentWithRemoteIpValve;
    }

    private String extractParameter(String paramName, String content) {
        Pattern paramPattern = Pattern.compile("(.*" + paramName + "\\s*=\\s*\")([^\"]+)(\".*)", 32);
        Matcher paramMatcher = paramPattern.matcher(content);
        String value = "";
        while (paramMatcher.find()) {
            value = paramMatcher.replaceFirst("$2");
        }
        return value;
    }

    private String sanitizeReplacement(String replacement) {
        return replacement.replaceAll("\\$", "\\\\\\$");
    }

    private String removeParam(String paramName, String content) {
        Pattern paramPattern = Pattern.compile("(.*)(" + paramName + "\\s*=\\s*\"[^\"]+\")(.*)", 32);
        Matcher paramMatcher = paramPattern.matcher(content);
        String newContent = "";
        while (paramMatcher.find()) {
            newContent = paramMatcher.replaceFirst("$1$3");
        }
        return newContent;
    }
}

