CREATE TABLE CHOICEVALUE (
    ID bigint NOT NULL,
    CHOICEVALUE varchar(255) NOT NULL,
    LABEL varchar(255) NOT NULL,
    SEQUENCE int default NULL,
    COLUMN_ID bigint NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT FK_CHOICEVALUE_COLUMN
        FOREIGN KEY (COLUMN_ID)
            REFERENCES SNOWCOLUMN(ID)
            ON DELETE CASCADE
);

ALTER TABLE SNOWCOLUMN ADD COLUMNLABEL VARCHAR(255);
ALTER TABLE SNOWCOLUMN ADD REFERENCE VARCHAR(255);
ALTER TABLE SNOWCOLUMN ADD CHOICE int;
ALTER TABLE SNOWCOLUMN ADD ISFORMTITLECOLUMN BOOLEAN DEFAULT FALSE NOT NULL;
ALTER TABLE SNOWCOLUMN ADD DVTYPE VARCHAR(255);
ALTER TABLE SNOWCOLUMN ADD DVLENGTH INTEGER;
ALTER TABLE SNOWCOLUMN ADD DVISARRAYTYPE BOOLEAN;

CREATE TABLE FORMELEMENT (
    ID bigint NOT NULL,
    COLUMNNAME varchar(255) NOT NULL,
    POSITION int default NULL,
    INTERNALTYPE varchar(255),
    MAXLENGTH int default NULL,
    TYPE VARCHAR(20) NOT NULL,
    SYNCHRONIZATION_ID BIGINT NOT NULL,
    CREATEDAT TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (ID),
    CONSTRAINT FK_FORMELEMENT_SYNCHRONIZATION
        FOREIGN KEY (SYNCHRONIZATION_ID)
        REFERENCES SYNCHRONIZATION(ID)
        ON DELETE CASCADE
);