DROP TABLE IF EXISTS synchronizationView;
DROP VIEW IF EXISTS synchronizationView;

CREATE VIEW synchronizationView AS
SELECT sync.id,
    sync.manual,
    sync.waiting,
    sync.enabled,
    sync.name,
    CASEWHEN (NEXT_FIRE_TIME = '-1', NULL, NEXT_FIRE_TIME) AS nextStartLong,
    a.id AS lastLog_id,
    TIMESTAMPDIFF(SECOND, startDate, endDate) * 1000 AS lastDuration
FROM SYNCHRONIZATION AS sync 
    LEFT JOIN QRTZ_TRIGGERS ON CONCAT('SyncId_', sync.id) = QRTZ_TRIGGERS.TRIGGER_NAME
    LEFT JOIN (select * from ACTIVITYLOG act where act.id in (select max(al.id) as maxid from ACTIVITYLOG al group by al.synchronization)) AS a ON sync.id = a.synchronization;
