DROP VIEW IF EXISTS activityLogView;
CREATE VIEW activityLogView AS
  SELECT
      al.id
    , al.synchronization
    , al.type
    , al.startedBy
    , al.scheduledStart
    , al.startDate
    , al.endDate
    , al.status
    , al.migrationStatus
    , al.insertedCount
    , al.updatedCount
    , al.deletedCount
    , al.totalToInsert
    , al.totalToUpdate
    , al.totalToDelete
    , (al.insertedCount + al.updatedCount + al.deletedCount) AS total
    , TIMESTAMPDIFF(SECOND, al.startDate, al.endDate) * 1000 AS duration
    , st.TYPE as snowtableType
  FROM
    ACTIVITYLOG al
    JOIN SYNCHRONIZATION sync ON al.SYNCHRONIZATION = sync.ID
    JOIN SNOWTABLE st ON sync.SNOWTABLE_ID = st.ID;
