-- Add new permissions
INSERT INTO [${schema}].permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE FROM [${schema}].SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC');

INSERT INTO [${schema}].permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE + 1 FROM [${schema}].SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL');

INSERT INTO [${schema}].permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE + 2 FROM [${schema}].SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF');

INSERT INTO [${schema}].permission (id, permission_name)
VALUES ((SELECT SEQ_NEXT_VALUE + 3 FROM [${schema}].SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM');

UPDATE [${schema}].SEQUENCE_TABLE_GENERATOR
SET SEQ_NEXT_VALUE = SEQ_NEXT_VALUE + 4
WHERE SEQ_TABLE_NAME = 'PERMISSION';

DELETE
FROM [${schema}].role_permission
WHERE permission_id = (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE');

DELETE
FROM [${schema}].permission
WHERE permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE';

INSERT INTO [${schema}].role_permission(role_id, permission_id)
VALUES ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM')),

       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM')),

       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF')),
       ((SELECT r.id FROM [${schema}].role r WHERE role_name = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM [${schema}].permission p WHERE p.permission_name = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM'));