CREATE VIEW [${schema}].minNextFullStartView AS
    SELECT
        sync.id as sync_id
       , MIN((CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)) as nextFullStartLong
    FROM [${schema}].synchronization sync
    LEFT JOIN [${schema}].scheduler fullScheduler      ON fullScheduler.sync_id = sync.id
    LEFT JOIN [${schema}].QRTZ_TRIGGERS qrtz_full        ON        qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and        qrtz_full.TRIGGER_NAME = 'SyncId_' + CAST(sync.id AS VARCHAR(50)) + '_SchedulerId_' + CAST(fullScheduler.id AS VARCHAR(50)) + '_AdditionalSchedulerLoad'        and        qrtz_full.TRIGGER_GROUP = 'DEFAULT'
    GROUP BY sync.id;