CREATE VIEW `activityLogView` AS
SELECT
    `al`.`id`,
    `al`.`synchronization`,
    `al`.`type`,
    `al`.`startedBy`,
    `al`.`scheduledStart`,
    `al`.`startDate`,
    `al`.`endDate`,
    `al`.`status`,
    `al`.`migrationStatus`,
    `al`.`insertedCount`,
    `al`.`updatedCount`,
    `al`.`deletedCount`,
    `al`.`totalToInsert`,
    `al`.`totalToUpdate`,
    `al`.`totalToDelete`,
    (`al`.`insertedCount` + `al`.`updatedCount` + `al`.`deletedCount`) AS `total`,
    (timestampdiff(SECOND,`al`.`startDate`,`al`.`endDate`) * 1000) AS `duration`
from `activityLog` `al`;
