CREATE OR REPLACE VIEW "ACTIVITYLOGVIEW" AS
  SELECT
      al.id
    , al.synchronization
    , al.type
    , al.startedBy
    , al.scheduledStart
    , al.startDate
    , al.endDate
    , al.status
    , al.migrationStatus
    , al.insertedCount
    , al.updatedCount
    , al.deletedCount
    , al.totalToInsert
    , al.totalToUpdate
    , al.totalToDelete
    , (al.insertedCount + al.updatedCount + al.deletedCount) AS total
    , (CAST(al.endDate AS DATE) - CAST(al.startDate AS DATE)) * 24 * 60 * 60 * 1000 AS duration
    , st.type as snowtableType
  FROM "ACTIVITYLOG" al
    JOIN "SYNCHRONIZATION" sync ON al.synchronization = sync.id
    JOIN "SNOWTABLE" st ON sync.snowtable_id = st.id
