CREATE OR REPLACE VIEW synchronizationView AS
SELECT sync.id,
	sync.manual,
	sync.waiting,
	sync.enabled,
	sync.name,
	NEXT_FIRE_TIME AS nextStartLong,
	a.id AS lastLog_id,
	(CAST(endDate AS DATE) - CAST(startDate AS DATE)) * 24 * 60 * 60 * 1000 AS lastDuration
FROM synchronization sync
	LEFT JOIN QRTZ_TRIGGERS ON 'SyncId_' || sync.id = QRTZ_TRIGGERS.TRIGGER_NAME
	LEFT JOIN ( SELECT startDate,
					endDate,
					synchronization,
					id
				FROM activityLog
				WHERE id IN (SELECT MAX(id) FROM activitylog GROUP BY synchronization)) a
		ON sync.id = a.synchronization

