CREATE TABLE "DATASTORAGE"
(
    "ID"           NUMBER(19, 0) NOT NULL ENABLE,
    "DATA"         CLOB,
    "DATAASSTRING" VARCHAR2(4000 CHAR),
    PRIMARY KEY ("ID")
);

ALTER TABLE "ACTIVITYLOG"
    ADD ("ACTIVITYDATASTORAGE_ID" NUMBER(19, 0), "RESUMEDATASTORAGE_ID" NUMBER(19, 0));

ALTER TABLE "ACTIVITYLOG" ADD CONSTRAINT "FK_ACTIVITYDATASTORAGE_ID" FOREIGN KEY ("ACTIVITYDATASTORAGE_ID") REFERENCES "DATASTORAGE"("ID");
ALTER TABLE "ACTIVITYLOG" ADD CONSTRAINT "FK_RESUMEDATASTORAGE_ID" FOREIGN KEY ("RESUMEDATASTORAGE_ID") REFERENCES "DATASTORAGE"("ID");

INSERT INTO "DATASTORAGE" ("ID", "DATA")
SELECT "ID", "RESUMESTATE" as "DATA"
FROM "ACTIVITYLOG"
WHERE STATUS = 'FAILED'
      AND RESUMESTATE IS NOT NULL;

INSERT INTO "SEQUENCE_TABLE_GENERATOR"("SEQ_TABLE_NAME", "SEQ_NEXT_VALUE")
VALUES ('DATA_STORAGE', COALESCE((SELECT (MAX("ID") + 11) from "DATASTORAGE"), 0));

ALTER TABLE "ACTIVITYLOG" DROP ("RESUMESTATE", "RESUMESTATESTRING");