CREATE TABLE "${schema}".choiceValue (
    id bigint NOT NULL,
    choiceValue character varying(255),
    label character varying(255),
    sequence INTEGER NULL,
    column_id bigint NOT NULL
);

ALTER TABLE ONLY "${schema}".choiceValue
    ADD CONSTRAINT choicevalue_pkey PRIMARY KEY (id);

ALTER TABLE ONLY "${schema}".choiceValue
    ADD CONSTRAINT fk_choicevalue_column
        FOREIGN KEY (column_id)
            REFERENCES "${schema}".snowcolumn(id)
            ON DELETE CASCADE;

ALTER TABLE "${schema}".snowcolumn ADD COLUMN columnLabel varchar DEFAULT NULL;
ALTER TABLE "${schema}".snowcolumn ADD COLUMN reference varchar DEFAULT NULL;
ALTER TABLE "${schema}".snowcolumn ADD COLUMN choice integer DEFAULT NULL;
ALTER TABLE "${schema}".snowcolumn ADD COLUMN isFormTitleColumn BOOLEAN DEFAULT false;
ALTER TABLE "${schema}".snowcolumn ADD COLUMN dvType varchar DEFAULT NULL;
ALTER TABLE "${schema}".snowcolumn ADD COLUMN dvLength integer DEFAULT NULL;
ALTER TABLE "${schema}".snowcolumn ADD COLUMN dvIsArrayType boolean DEFAULT NULL;

CREATE TABLE "${schema}".formElement (
    id bigint NOT NULL,
    columnName character varying(255),
    position INTEGER NULL,
    internalType character varying(255),
    maxLength INTEGER NULL,
    type character varying(20) NOT NULL,
    sequence INTEGER NULL,
    createdAt TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP,
    synchronization_id BIGINT NOT NULL
);

ALTER TABLE ONLY "${schema}".formElement
    ADD CONSTRAINT formelement_pkey PRIMARY KEY (id);

ALTER TABLE "${schema}".formElement
    ADD CONSTRAINT fk_formElement_synchronization
    FOREIGN KEY (synchronization_id)
    REFERENCES "${schema}".synchronization(id)
    ON DELETE CASCADE;
