#!/bin/bash
#
# snowmirror
#
# chkconfig: 2345 80 10
# description:  Start up the SnowMirror Tomcat server.

# Source function library.
if [ -f /lib/lsb/init-functions ]; then
	. /lib/lsb/init-functions
elif [ -f /etc/init.d/functions ]; then
	. /etc/init.d/functions
fi

# Run the service as the following user
USER=root

# Absolute path to SnowMirror installation directory
CATALINA_HOME="/opt/SnowMirror"

RETVAL=$?

case "$1" in
 # Start command
 start)
        if [ -f $CATALINA_HOME/run.sh ];
          then
            echo $"Starting SnowMirror"
            /bin/su $USER $CATALINA_HOME/run.sh
        fi
        ;;
 # Stop command
 stop)
        if [ -f $CATALINA_HOME/shutdown.sh ];
          then
            echo $"Stopping SnowMirror"
            /bin/su $USER $CATALINA_HOME/shutdown.sh
        fi
        ;;
 *)
        echo $"Usage: /etc/init.d/snow-mirror {start|stop}"
        exit 1
        ;;
esac

exit $RETVAL
