CREATE TABLE `dataStorage`
(
    `id`           bigint NOT NULL,
    `data`         LONGTEXT,
    `dataAsString` LONGTEXT,
    PRIMARY KEY (`id`)
);

ALTER TABLE `activityLog`
    ADD `activityDataStorage_id` bigint,
    ADD `resumeDataStorage_id`   bigint;

ALTER TABLE `activityLog`
    ADD CONSTRAINT `fk_activityDataStorage_id` FOREIGN KEY (`activityDataStorage_id`) REFERENCES `dataStorage` (`id`),
    ADD CONSTRAINT `fk_resumeDataStorage_id` FOREIGN KEY (`resumeDataStorage_id`) REFERENCES `dataStorage` (`id`);

INSERT INTO `dataStorage` (`id`, `data`)
SELECT `id`, `resumeState` as `data`
FROM `activityLog`
WHERE status = 'FAILED'
  AND `resumeState` IS NOT NULL;

INSERT INTO `SEQUENCE_TABLE_GENERATOR`(`SEQ_TABLE_NAME`, `SEQ_NEXT_VALUE`)
VALUES ('DATA_STORAGE', (SELECT COALESCE(MAX(`id`) + 11, 0) FROM `dataStorage`));

ALTER TABLE `activityLog`
    DROP COLUMN `resumeState`,
    DROP COLUMN `resumeStateString`;