-- Improving performance of synchronizationView. Note that due to performance reasons the view consists of two parts.
-- The first one is for synchronizations with activityLog and the second for synchronizations without activity log
-- (i.e. those which have not run yet).

DROP VIEW synchronizationView;
CREATE VIEW "${schema}".synchronizationView AS
  (
-- select synchronizations which have at least one activity log
    SELECT sync.id,
      sync.manual,
      sync.waiting,
      sync.enabled,
      sync.name,
      (CASE WHEN incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) as nextIncrementalStartLong,
      (CASE WHEN fullScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) as nextFullStartLong,
      LEAST(
          (CASE WHEN incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1' THEN null ELSE  qrtz_incremental.NEXT_FIRE_TIME END),
          (CASE WHEN fullScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
      ) as nextStartLong,
      a.id AS lastLog_id,
      EXTRACT(EPOCH FROM (a.endDate - a.startDate)) * 1000 AS lastDuration
    FROM SYNCHRONIZATION AS sync
      JOIN "${schema}".SCHEDULER incrementalScheduler ON sync.INC_SCHEDULER_ID = incrementalScheduler.ID
      LEFT JOIN "${schema}".SCHEDULER fullScheduler ON sync.FULL_SCHEDULER_ID = fullScheduler.ID
      LEFT JOIN "${schema}".QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and CONCAT('SyncId_', sync.ID) = qrtz_incremental.TRIGGER_NAME and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
      LEFT JOIN "${schema}".QRTZ_TRIGGERS qrtz_full ON qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and CONCAT('CleanAndSync_SyncId_', sync.id) = qrtz_full.TRIGGER_NAME and qrtz_full.TRIGGER_GROUP = 'DEFAULT',
      ACTIVITYLOG a -- it is much faster to join it using WHERE clause instead of JOIN
    WHERE
-- join the latest activity log.
      sync.id = a.SYNCHRONIZATION AND a.id in (select max(al.ID) as maxid from ACTIVITYLOG al group by al.SYNCHRONIZATION)
  )
  UNION
  (
-- select synchronizations which have no activity log
    SELECT sync.id,
      sync.manual,
      sync.waiting,
      sync.enabled,
      sync.name,
      (CASE WHEN incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) as nextIncrementalStartLong,
      (CASE WHEN fullScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) as nextFullStartLong,
      LEAST(
          (CASE WHEN incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END),
          (CASE WHEN fullScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
      ) as nextStartLong,
      null AS lastLog_id,
      null AS lastDuration
    FROM SYNCHRONIZATION AS sync
      JOIN "${schema}".SCHEDULER incrementalScheduler ON sync.INC_SCHEDULER_ID = incrementalScheduler.ID
      LEFT JOIN "${schema}".SCHEDULER fullScheduler ON sync.FULL_SCHEDULER_ID = fullScheduler.ID
      LEFT JOIN "${schema}".QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and CONCAT('SyncId_', sync.ID) = qrtz_incremental.TRIGGER_NAME and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
      LEFT JOIN "${schema}".QRTZ_TRIGGERS qrtz_full ON qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and CONCAT('CleanAndSync_SyncId_', sync.id) = qrtz_full.TRIGGER_NAME and qrtz_full.TRIGGER_GROUP = 'DEFAULT'
    WHERE
      not exists (SELECT al.id FROM activityLog al WHERE al.SYNCHRONIZATION = sync.id)
  )
