@echo off
rem Licensed to the Apache Software Foundation (ASF) under one or more
rem contributor license agreements.  See the NOTICE file distributed with
rem this work for additional information regarding copyright ownership.
rem The ASF licenses this file to You under the Apache License, Version 2.0
rem (the "License"); you may not use this file except in compliance with
rem the License.  You may obtain a copy of the License at
rem
rem     http://www.apache.org/licenses/LICENSE-2.0
rem
rem Unless required by applicable law or agreed to in writing, software
rem distributed under the License is distributed on an "AS IS" BASIS,
rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
rem See the License for the specific language governing permissions and
rem limitations under the License.

if "%OS%" == "Windows_NT" setlocal
rem ---------------------------------------------------------------------------
rem Stop script for the CATALINA Server
rem
rem $Id: shutdown.bat 895392 2010-01-03 14:02:31Z kkolinko $
rem ---------------------------------------------------------------------------

rem Guess CATALINA_HOME if not defined
set "CURRENT_DIR=%cd%"
if not "%CATALINA_HOME%" == "" goto gotHome
set "CATALINA_HOME=%CURRENT_DIR%"
if exist "%CATALINA_HOME%\bin\catalina.bat" goto okHome
cd ..
set "CATALINA_HOME=%cd%"
cd "%CURRENT_DIR%"
:gotHome
if exist "%CATALINA_HOME%\bin\catalina.bat" goto okHome
echo The CATALINA_HOME environment variable is not defined correctly
echo This environment variable is needed to run this program
goto end
:okHome

set "EXECUTABLE=%CATALINA_HOME%\bin\catalina.bat"

rem Check that target executable exists
if exist "%EXECUTABLE%" goto okExec
echo Cannot find "%EXECUTABLE%"
echo This file is needed to run this program
goto end
:okExec

rem Get remaining unshifted command line arguments and save them in the
set CMD_LINE_ARGS=
:setArgs
if ""%1""=="""" goto doneSetArgs
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto setArgs
:doneSetArgs













if "%CURRENT_DIR%" == "" set "CURRENT_DIR=%cd%"
set APP_CONFFILE=%CURRENT_DIR%\snowMirror.properties

:checkCurrentDir
rem Check if user is in root installer directory
if exist "%CURRENT_DIR%\bin\startup.bat" goto init
echo The 'CURRENT_DIR' variable must be set to root standalone installer folder, or the script must be executed from that folder.
goto end

:init
REM Parse Application port number
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.port" "%APP_CONFFILE%"') do set "APP_PORT=%%a"
set "APP_PORT=%APP_PORT: =%"
IF ["%APP_PORT%"] EQU ["="] SET APP_PORT=""
IF ["%APP_PORT%"] EQU [" = "] SET APP_PORT=""
IF ["%APP_PORT%"] EQU ["= "] SET APP_PORT=""
IF ["%APP_PORT%"] EQU [" ="] SET APP_PORT=""

REM Parse Control port number
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.controlport" "%APP_CONFFILE%"') do set "CONTROL_PORT=%%a"
set "CONTROL_PORT=%CONTROL_PORT: =%"
IF ["%CONTROL_PORT%"] EQU ["="] SET CONTROL_PORT=""
IF ["%CONTROL_PORT%"] EQU [" = "] SET CONTROL_PORT=""
IF ["%CONTROL_PORT%"] EQU ["= "] SET CONTROL_PORT=""
IF ["%CONTROL_PORT%"] EQU [" ="] SET CONTROL_PORT=""

REM Parse Application context
for /f "tokens=2 delims==" %%a in ('findstr /b /i "snowMirror.context" "%APP_CONFFILE%"') do set "APP_CONTEXT=%%a"
set "APP_CONTEXT=%APP_CONTEXT: =%"
IF ["%APP_CONTEXT%"] EQU ["="] SET APP_CONTEXT=""
IF ["%APP_CONTEXT%"] EQU [" = "] SET APP_CONTEXT=""
IF ["%APP_CONTEXT%"] EQU ["= "] SET APP_CONTEXT=""
IF ["%APP_CONTEXT%"] EQU [" ="] SET APP_CONTEXT=""

REM Set JAVA_OPTS passed to server by catalina.bat
set JAVA_OPTS=%JAVA_OPTS% -Dtomcat.http.port=%APP_PORT% -Dtomcat.http.controlport=%CONTROL_PORT% -Dtomcat.snowMirror.context=%APP_CONTEXT%
if [%APP_JAVA_OPTS%] NEQ [""] set "JAVA_OPTS=%JAVA_OPTS% %APP_JAVA_OPTS%"

call "%EXECUTABLE%" stop %CMD_LINE_ARGS%

:end
