CREATE TABLE [${schema}].[asyncNotification] (
  [id] [bigint] NOT NULL PRIMARY KEY,
  [asyncName] [varchar](255) NOT NULL,
  [subName] [varchar](255) default NULL,
  [description] [varchar](max) default NULL,
  [status] [varchar](100) NOT NULL,
  [totalCount] [int] NOT NULL default 0,
  [totalDone] [int] NOT NULL default 0,
  UNIQUE ([asyncName])
);

CREATE TABLE [${schema}].[asyncNotificationMessage] (
  id [bigint] NOT NULL PRIMARY KEY,
  [notificationId] [bigint] NOT NULL,
  [type] [varchar](255) NOT NULL,
  [message] [varchar](max) NOT NULL,
  [createTime] [datetime2] NOT NULL,
  CONSTRAINT [fk_asyncNotificationMessage_notificationId] FOREIGN KEY([notificationId]) REFERENCES [${schema}].[asyncNotification]([id])
);
