CREATE VIEW synchronizationView AS
SELECT sync.id,
    sync.manual,
    sync.waiting,
    sync.enabled,
    sync.name,
    IF (NEXT_FIRE_TIME = '-1', NULL, NEXT_FIRE_TIME) AS nextStartLong,
    a.id AS lastLog_id,
    TIMESTAMPDIFF(SECOND, startDate, endDate) * 1000 AS lastDuration
FROM synchronization sync 
    LEFT JOIN QRTZ_TRIGGERS ON CONCAT('SyncId_', sync.id) = QRTZ_TRIGGERS.TRIGGER_NAME
    LEFT JOIN activityLog a ON  a.id = (SELECT al.id FROM activityLog al WHERE al.synchronization = sync.id ORDER BY al.id DESC LIMIT 1);