-- Alter table config 
ALTER TABLE `config` ADD COLUMN `comment` text DEFAULT NULL;
ALTER TABLE `config` ADD COLUMN `isDefaultValue` tinyint DEFAULT 1;

UPDATE `config` SET `isDefaultValue` = 0;

-- Adding new permissions because we need to prevent non-administrators from being able to About:config page
insert into permission (id, permission_name) values (14, 'PERMISSION_ABOUT_CONFIG');
insert into role_permission (role_id, permission_id) values (1, 14);

-- We happened to have multiple 'PERMISSION' tables in sequence generator -> clean them
DELETE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION' AND SEQ_NEXT_VALUE = 8;
DELETE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION' AND SEQ_NEXT_VALUE = 12;
UPDATE SEQUENCE_TABLE_GENERATOR SET SEQ_NEXT_VALUE = 15 WHERE SEQ_TABLE_NAME = 'PERMISSION';

commit;
