CREATE INDEX "idx_fk_activityLog_sync" ON "ACTIVITYLOG"("SYNCHRONIZATION");
CREATE INDEX "idx_fk_asyncMssg_notifId" ON "ASYNCNOTIFICATIONMESSAGE"("NOTIFICATIONID");
CREATE INDEX "idx_fk_idx_col_idx_id" ON "INDEX_COLUMN"("INDEX_ID");
CREATE INDEX "idx_fk_idx_col_column_id" ON "INDEX_COLUMN"("COLUMN_ID");
CREATE INDEX "idx_fk_notif_sync_id" ON "NOTIFICATION"("SYNCHRONIZATION_ID");
CREATE INDEX "idx_fk_qrtz_trig_job_name" ON QRTZ_TRIGGERS(JOB_NAME);
CREATE INDEX "idx_fk_qrtz_trig_job_grp" ON QRTZ_TRIGGERS(JOB_GROUP);
CREATE INDEX "idx_fk_role_perm_role_id" ON "ROLE_PERMISSION"("ROLE_ID");
CREATE INDEX "idx_fk_role_perm_perm_id" ON "ROLE_PERMISSION"("PERMISSION_ID");
CREATE INDEX "idx_fk_snowColumn_stable_id" ON "SNOWCOLUMN"("SNOWTABLE_ID");
CREATE INDEX "idx_fk_snowColumn_l_stable_id" ON "SNOWCOLUMN"("LATEST_SNOWTABLE_ID");
CREATE INDEX "idx_fk_sync_inc_sched_id" ON "SYNCHRONIZATION"("INC_SCHEDULER_ID");
CREATE INDEX "idx_fk_sync_full_sched_id" ON "SYNCHRONIZATION"("FULL_SCHEDULER_ID");
CREATE INDEX "idx_fk_sync_snowTable_id" ON "SYNCHRONIZATION"("SNOWTABLE_ID");
CREATE INDEX "idx_fk_user_role_users_id" ON "USER_ROLE"("USERS_ID");
CREATE INDEX "idx_fk_user_role_roles_id" ON "USER_ROLE"("ROLES_ID");
CREATE INDEX "idx_fk_sync_last_log_id" ON "SYNCHRONIZATION"(LASTLOG_ID);
CREATE INDEX "idx_fk_sync_name" ON "SYNCHRONIZATION"(NAME);

CREATE OR REPLACE VIEW minFireTimeView AS
  SELECT   JOB_NAME, MIN(NEXT_FIRE_TIME) as NEXT_FIRE_TIME
  FROM     QRTZ_TRIGGERS
  WHERE    SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0'
           AND NEXT_FIRE_TIME > 0
           AND (TRIGGER_STATE = 'WAITING' OR TRIGGER_STATE = 'ACQUIRED' OR TRIGGER_STATE = 'BLOCKED')
  GROUP BY JOB_NAME;


CREATE OR REPLACE VIEW minFiredTimeView AS
  SELECT   JOB_NAME, MIN(FIRED_TIME) as minFiredTime
  FROM     QRTZ_FIRED_TRIGGERS
  WHERE    SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0'
  GROUP BY JOB_NAME;


CREATE OR REPLACE VIEW synchronizationView AS
  SELECT
    sync.id
    , sync.manual
    , (CASE WHEN qrtz.NEXT_FIRE_TIME < ((-- what follows is current unix timestamp
                                          EXTRACT(DAY FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))*86400
                                          + EXTRACT(HOUR FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))*3600
                                          + EXTRACT(MINUTE FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))*60
                                          + EXTRACT(SECOND FROM (CURRENT_TIMESTAMP at time zone 'UTC' -TIMESTAMP '1970-01-01 00:00:00 +00:00'))
                                        ) * 1000 + 1000) THEN 1 ELSE 0 END) as waiting
    , (CASE WHEN qrtzFired.minFiredTime IS NOT NULL THEN 1 ELSE 0 END) as running
    , sync.enabled
    , sync.name
    , sync.mirrortablename
    , sync.deletetype
    , sync.snowtable_id
    , sync.created
    , sync.createdby
    , sync.updated
    , sync.updatedby
    , sync.includeinheritedcolumns
    , sync.updatebeforesync
    , sync.referencefieldtype
    , sync.schedulerPriority
    , (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' OR qrtz_incremental.NEXT_FIRE_TIME = -1 THEN NULL ELSE qrtz_incremental.NEXT_FIRE_TIME END) AS nextIncrementalStartLong
    , (CASE WHEN        fullScheduler.schedulerDefinitionType = 'MANUALLY' OR        qrtz_full.NEXT_FIRE_TIME = -1 THEN NULL ELSE qrtz_full.NEXT_FIRE_TIME END)        AS nextFullStartLong
    , qrtz.NEXT_FIRE_TIME as nextStartLong
    , a.id AS lastLog_id
    , a.startDate AS lastStartDate
    , a.status AS lastStatus
    , a.insertedcount AS lastInsertedCount
    , a.updatedcount AS lastUpdatedCount
    , a.deletedcount AS lastDeletedCount
    , a.insertedcount + a.updatedcount + a.deletedcount AS lastTotal
    , (CAST(a.endDate AS DATE) - CAST(a.startDate AS DATE)) * 24 * 60 * 60 * 1000 AS lastDuration
    , st.type AS snowtableType
    , st.userquery AS snowtableUserquery
    , incrementalScheduler.schedulerdefinitiontype AS incSchedulerDefinitionType
    , fullScheduler.schedulerdefinitiontype AS fullSchedulerDefinitionType
    , fullScheduler.executiontype AS fullSchedulerExecutionType
  FROM "SYNCHRONIZATION" sync
    JOIN "SNOWTABLE" st                      ON sync.snowtable_id = st.id
    JOIN "SCHEDULER" incrementalScheduler    ON sync.inc_scheduler_id = incrementalScheduler.id
    LEFT JOIN "SCHEDULER" fullScheduler      ON sync.full_scheduler_id = fullScheduler.id
    LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and qrtz_incremental.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.id, '_IncrementalLoad')) and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
    LEFT JOIN QRTZ_TRIGGERS qrtz_full        ON        qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and        qrtz_full.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.id, '_FullLoad'))        and        qrtz_full.TRIGGER_GROUP = 'DEFAULT'
    LEFT JOIN "ACTIVITYLOG" a                ON sync.lastLog_id = a.id
    LEFT JOIN minFireTimeView qrtz           ON      qrtz.JOB_NAME = CONCAT('SyncId_', sync.id)
    LEFT JOIN minFiredTimeView qrtzFired     ON qrtzFired.JOB_NAME = CONCAT('SyncId_', sync.id);
