-- Alter table config
ALTER TABLE "${schema}".config ADD COLUMN comment varchar DEFAULT NULL;
ALTER TABLE "${schema}".config ADD COLUMN isdefaultvalue boolean DEFAULT true NOT NULL;

UPDATE "${schema}".config SET isdefaultvalue = false;

-- Adding new permissions because we need to prevent non-administrators from being able to About:config page
insert into "${schema}".permission (id, permission_name) values (14, 'PERMISSION_ABOUT_CONFIG');
insert into "${schema}".role_permission (role_id, permission_id) values (1, 14);

-- We happened to have multiple 'PERMISSION' tables in sequence generator -> clean them
DELETE FROM "${schema}".SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION' AND SEQ_NEXT_VALUE = 8;
DELETE FROM "${schema}".SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION' AND SEQ_NEXT_VALUE = 12;
UPDATE "${schema}".SEQUENCE_TABLE_GENERATOR SET SEQ_NEXT_VALUE = 15 WHERE SEQ_TABLE_NAME = 'PERMISSION';

commit;