CREATE OR REPLACE VIEW "${schema}".synchronizationview AS
SELECT sync.id,
	sync.manual,
	sync.waiting,
	sync.enabled,
	sync.name,
	NEXT_FIRE_TIME AS nextStartLong,
	a.id AS lastLog_id,
	EXTRACT(EPOCH FROM (endDate - startDate)) * 1000 AS lastDuration
FROM "${schema}".synchronization sync 
	LEFT JOIN "${schema}".QRTZ_TRIGGERS ON CONCAT('SyncId_', sync.id) = QRTZ_TRIGGERS.TRIGGER_NAME
	LEFT JOIN "${schema}".activityLog a ON  a.id = (SELECT al.id FROM "${schema}".activityLog al WHERE al.synchronization = sync.id ORDER BY al.id DESC LIMIT 1)