-- We want to drop the "waiting" column but for some weird reason H2 fails to do it.
-- Therefore (as a workaround), we just remove "NOT NULL" so that we don't have to set it anywhere.
ALTER TABLE SYNCHRONIZATION ALTER COLUMN WAITING BOOLEAN NULL;

ALTER TABLE SYNCHRONIZATION ADD SCHEDULERPRIORITY TINYINT DEFAULT 2;

ALTER TABLE SYNCHRONIZATION ADD LASTLOG_ID BIGINT DEFAULT NULL;

-- Fill in lastLog_id field to preserve backward compatibility
UPDATE SYNCHRONIZATION s SET s.LASTLOG_ID = (SELECT MAX(a.ID) FROM ACTIVITYLOG a WHERE a.SYNCHRONIZATION = s.ID);
