CREATE VIEW minFireTimeView AS
SELECT   JOB_NAME, MIN(NEXT_FIRE_TIME) as NEXT_FIRE_TIME
FROM     QRTZ_TRIGGERS
WHERE    SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0'
         AND NEXT_FIRE_TIME > 0
         AND (TRIGGER_STATE = 'WAITING' OR TRIGGER_STATE = 'ACQUIRED' OR TRIGGER_STATE = 'BLOCKED')
GROUP BY JOB_NAME;

CREATE VIEW minFiredTimeView AS
SELECT   JOB_NAME, MIN(FIRED_TIME) as minFiredTime
FROM     QRTZ_FIRED_TRIGGERS
WHERE    SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0'
GROUP BY JOB_NAME;


DROP VIEW IF EXISTS synchronizationView;
CREATE VIEW synchronizationView AS
  SELECT
    sync.id
    , sync.manual
    , CASEWHEN(qrtz.NEXT_FIRE_TIME < (SELECT DATEDIFF('second', timestamp '1970-01-01 00:00:00' , CURRENT_TIMESTAMP()) * 1000), 1, 0) as waiting
    , CASEWHEN(qrtzFired.minFiredTime is not null, 1, 0) as running
    , sync.enabled
    , sync.name
    , sync.mirrortablename
    , sync.deletetype
    , sync.snowtable_id
    , sync.created
    , sync.createdby
    , sync.updated
    , sync.updatedby
    , sync.includeinheritedcolumns
    , sync.updatebeforesync
    , sync.referencefieldtype
    , sync.schedulerPriority
    , CASEWHEN (incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME) as nextIncrementalStartLong
    , CASEWHEN (fullScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1', NULL, qrtz_full.NEXT_FIRE_TIME) as nextFullStartLong
    , qrtz.NEXT_FIRE_TIME as nextStartLong
    , a.id AS lastLog_id
    , a.startDate AS lastStartDate
    , a.status AS lastStatus
    , a.insertedcount AS lastInsertedCount
    , a.updatedcount AS lastUpdatedCount
    , a.deletedcount AS lastDeletedCount
    , a.insertedcount + a.updatedcount + a.deletedcount AS lastTotal
    , TIMESTAMPDIFF(SECOND, a.startDate, a.endDate) * 1000 AS lastDuration
    , st.type AS snowtableType
    , st.userquery AS snowtableUserquery
    , incrementalScheduler.schedulerdefinitiontype AS incSchedulerDefinitionType
    , fullScheduler.schedulerdefinitiontype AS fullSchedulerDefinitionType
    , fullScheduler.executiontype AS fullSchedulerExecutionType
  FROM SYNCHRONIZATION AS sync
    JOIN SNOWTABLE st                        ON sync.snowtable_id = st.id
    JOIN SCHEDULER incrementalScheduler      ON sync.INC_SCHEDULER_ID = incrementalScheduler.ID
    LEFT JOIN SCHEDULER fullScheduler        ON sync.FULL_SCHEDULER_ID = fullScheduler.ID
    LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and qrtz_incremental.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.ID, '_IncrementalLoad')) and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
    LEFT JOIN QRTZ_TRIGGERS qrtz_full        ON        qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and        qrtz_full.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.ID, '_FullLoad'))        and        qrtz_full.TRIGGER_GROUP = 'DEFAULT'
    LEFT JOIN ACTIVITYLOG a                  ON sync.LASTLOG_ID = a.ID
    LEFT JOIN minFireTimeView qrtz           ON      qrtz.JOB_NAME = CONCAT('SyncId_', sync.id)
    LEFT JOIN minFiredTimeView qrtzFired     ON qrtzFired.JOB_NAME = CONCAT('SyncId_', sync.id);
