INSERT INTO [${schema}].[mirrorTable]([id], [name], [tmpName], [sync_id]) (
  SELECT ROW_NUMBER() OVER (ORDER BY [id] ASC), s.[mirrorTableName] as name, s.[tmpMirrorTableName] as tmpName, s.[id] as sync_id
  FROM [${schema}].[synchronization] s
  WHERE s.[mirrorTableName] IS NOT NULL
);

INSERT INTO [${schema}].[SEQUENCE_TABLE_GENERATOR] VALUES ('MIRROR_TABLE', (SELECT COALESCE(MAX([id]), 0) + 1 FROM [${schema}].[mirrorTable]));


CREATE TABLE [${schema}].[tableRotationSchedule] (
  [id] [bigint] NOT NULL,
  [sysId] [varchar](32) NOT NULL,
  [tableName] [varchar](255) NOT NULL,
  [validFrom] [datetime2],
  [validTo] [datetime2],
  [isoffline] [bit] DEFAULT 0 NOT NULL,
  [rotationGroup_id] [bigint] NOT NULL,
  CONSTRAINT [pk_trs_id] PRIMARY KEY ([id]),
  CONSTRAINT [fk_trs_rotationGroup_id] FOREIGN KEY ([rotationGroup_id]) REFERENCES [${schema}].[tableRotationGroup] ([id])
);

ALTER TABLE [${schema}].[synchronization] ADD [rotation] [varchar](20) CONSTRAINT "sync_rot_def_dis" DEFAULT 'DISABLED' NOT NULL;
ALTER TABLE [${schema}].[synchronization] ADD [rotationGroup_id] [bigint] CONSTRAINT "fk_sync_rotgr" FOREIGN KEY ([rotationGroup_id]) REFERENCES [${schema}].[tableRotationGroup]([id]);