ALTER VIEW [${schema}].[activityLogView] AS
  SELECT
      al.id
    , al.synchronization
    , al.type
    , al.startedBy
    , al.scheduledStart
    , al.startDate
    , al.endDate
    , al.status
    , al.migrationStatus
    , al.insertedCount
    , al.updatedCount
    , al.deletedCount
    , al.totalToInsert
    , al.totalToUpdate
    , al.totalToDelete
    , (CAST(al.insertedCount AS BIGINT) + al.updatedCount + al.deletedCount) AS total
    , al.recordsCounted
    , al.totalKeysForDiff
    , al.keysForDiffDownloaded
    , DATEDIFF(SECOND, al.startDate, al.endDate) * 1000 AS duration
    , st.type as snowtableType
  FROM
    [${schema}].[activityLog] al
    JOIN [${schema}].[synchronization] sync ON al.[synchronization] = sync.[id]
    JOIN [${schema}].[snowTable] st ON sync.[snowTable_id] = st.[id]
