CREATE OR REPLACE VIEW minNextFullStartView AS
SELECT   sync.id as sync_id, MIN((CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)) as nextFullStartLong
FROM     synchronization sync
             LEFT JOIN scheduler fullScheduler      ON fullScheduler.sync_id = sync.id
             LEFT JOIN QRTZ_TRIGGERS qrtz_full        ON        qrtz_full.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and        qrtz_full.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.id, CONCAT('_SchedulerId_', CONCAT(fullScheduler.id, '_AdditionalSchedulerLoad'))))        and        qrtz_full.TRIGGER_GROUP = 'DEFAULT'
GROUP BY sync.id;