CREATE TABLE PERMISSION (ID BIGINT NOT NULL, PERMISSION_NAME VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE ROLE (ID BIGINT NOT NULL, ROLE_NAME VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE ROLE_PERMISSION (ROLE_ID BIGINT NOT NULL, PERMISSION_ID BIGINT NOT NULL, CONSTRAINT FKBD40D5385E18A62B FOREIGN KEY (PERMISSION_ID) REFERENCES PUBLIC.PERMISSION (ID) ON DELETE RESTRICT, CONSTRAINT FKBD40D53860B59A0B FOREIGN KEY (ROLE_ID) REFERENCES PUBLIC.ROLE (ID) ON DELETE RESTRICT);
CREATE TABLE USERS (ID BIGINT NOT NULL, ACTIVE BOOLEAN NOT NULL, PASSWORD VARCHAR(255), USERNAME VARCHAR(255), TIMEZONE VARCHAR(255) DEFAULT 'Europe/Prague', PRIMARY KEY (ID));
CREATE TABLE USER_ROLE (USERS_ID BIGINT NOT NULL, ROLES_ID BIGINT NOT NULL, CONSTRAINT FK143BF46A546A2CE FOREIGN KEY (USERS_ID) REFERENCES PUBLIC.USERS (ID) ON DELETE RESTRICT, CONSTRAINT FK143BF46AFECE1264 FOREIGN KEY (ROLES_ID) REFERENCES PUBLIC.ROLE (ID) ON DELETE RESTRICT);
CREATE TABLE SEQUENCE_TABLE_GENERATOR (SEQ_TABLE_NAME VARCHAR(255), SEQ_NEXT_VALUE INTEGER);
CREATE TABLE SCHEDULER (ID BIGINT NOT NULL, CRONEXPRESSION VARCHAR(255), DAYOFMONTH INTEGER, DAYOFYEAR INTEGER, DAYSOFWEEK INTEGER, "HOUR" INTEGER, "MINUTE" INTEGER, PERIOD INTEGER, SCHEDULERDEFINITIONTYPE VARCHAR(255), "SECOND" INTEGER, STARTDATE TIMESTAMP, PRIMARY KEY (ID));
CREATE TABLE SNOWTABLE (ID BIGINT NOT NULL, HASUPDATEDONCOLUMN BOOLEAN NOT NULL, NAME VARCHAR(255), PREFIX VARCHAR(255), SYSID VARCHAR(255), USERQUERY VARCHAR(1000), PRIMARY KEY (ID));
CREATE TABLE SYNCHRONIZATION (ID BIGINT NOT NULL, CREATED TIMESTAMP, CREATEDBY VARCHAR(255), ENABLED BOOLEAN NOT NULL, MANUAL BOOLEAN NOT NULL, MIRRORTABLENAME VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, DELETETYPE VARCHAR(255) NOT NULL, UPDATED TIMESTAMP, UPDATEDBY VARCHAR(255), WAITING BOOLEAN NOT NULL, SCHEDULER_ID BIGINT, SNOWTABLE_ID BIGINT, PRIMARY KEY (ID), CONSTRAINT FK4F99F26092C0842D FOREIGN KEY (SCHEDULER_ID) REFERENCES PUBLIC.SCHEDULER (ID) ON DELETE RESTRICT, CONSTRAINT FK4F99F260CF389574 FOREIGN KEY (SNOWTABLE_ID) REFERENCES PUBLIC.SNOWTABLE (ID) ON DELETE RESTRICT);
CREATE TABLE NOTIFICATION (ID BIGINT NOT NULL, NOTIFICATIONRECEIVER VARCHAR(255), NOTIFICATIONTYPE VARCHAR(255), SYNCHRONIZATION_ID BIGINT, PRIMARY KEY (ID), CONSTRAINT FK237A88EB8FF4AA4D FOREIGN KEY (SYNCHRONIZATION_ID) REFERENCES PUBLIC.SYNCHRONIZATION (ID) ON DELETE RESTRICT);
CREATE TABLE SNOWCOLUMN (ID BIGINT NOT NULL, LENGTH INTEGER, NAME VARCHAR(255), SYSID VARCHAR(255), TYPE VARCHAR(255), SNOWTABLE_ID BIGINT, PRIMARY KEY (ID), CONSTRAINT FK8CB142B9CF389574 FOREIGN KEY (SNOWTABLE_ID) REFERENCES PUBLIC.SNOWTABLE (ID) ON DELETE RESTRICT);
CREATE TABLE ACTIVITYLOG (ID BIGINT NOT NULL, DELETEDCOUNT INTEGER, ENDDATE TIMESTAMP, INSERTEDCOUNT INTEGER, LOGS VARCHAR(1048576), STARTDATE TIMESTAMP, STARTEDBY VARCHAR(255), STATUS VARCHAR(255), TOTALTODELETE INTEGER, TOTALTOINSERT INTEGER, TOTALTOUPDATE INTEGER, TYPE VARCHAR(255), UPDATEDCOUNT INTEGER, SYNCHRONIZATION BIGINT, PRIMARY KEY (ID), CONSTRAINT FKC95329B59398B953 FOREIGN KEY (SYNCHRONIZATION) REFERENCES PUBLIC.SYNCHRONIZATION (ID) ON DELETE RESTRICT);
