CREATE TABLE MIRRORTABLE (
  ID BIGINT NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  TMPNAME VARCHAR(255),
  SHARDSCHEDULESYSID VARCHAR2(32),
  SYNC_ID BIGINT NOT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT UNQ_MIRR_TBL_NAME UNIQUE (NAME),
  CONSTRAINT FK_MIRR_TBL_SYNC_ID FOREIGN KEY (SYNC_ID) REFERENCES PUBLIC.SYNCHRONIZATION (ID) ON DELETE RESTRICT
);

CREATE TABLE TABLEROTATIONGROUP (
  ID BIGINT NOT NULL,
  ROTATIONTYPE VARCHAR(20) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE TABLEROTATIONSCHEDULE (
  ID BIGINT NOT NULL,
  SYSID VARCHAR(32) NOT NULL,
  TABLENAME VARCHAR(255) NOT NULL,
  VALIDFROM TIMESTAMP,
  VALIDTO TIMESTAMP,
  ISOFFLINE BOOLEAN DEFAULT FALSE NOT NULL,
  ROTATIONGROUP_ID BIGINT NOT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT FK_TRS_ROTATIONGROUP_ID FOREIGN KEY (ROTATIONGROUP_ID) REFERENCES PUBLIC.TABLEROTATIONGROUP (ID) ON DELETE RESTRICT
);

INSERT INTO MIRRORTABLE(ID, NAME, TMPNAME, SYNC_ID) (SELECT rownum() ID, S.MIRRORTABLENAME NAME, S.TMPMIRRORTABLENAME TMPNAME, S.ID SYNC_ID FROM SYNCHRONIZATION S WHERE S.MIRRORTABLENAME IS NOT NULL);

INSERT INTO SEQUENCE_TABLE_GENERATOR(SEQ_TABLE_NAME, SEQ_NEXT_VALUE) VALUES ('MIRROR_TABLE', (SELECT COALESCE(MAX(ID), 0) + 1 FROM MIRRORTABLE));

ALTER TABLE SYNCHRONIZATION ADD COLUMN ROTATION VARCHAR(20) DEFAULT 'DISABLED' NOT NULL;
ALTER TABLE SYNCHRONIZATION ADD COLUMN ROTATIONGROUP_ID BIGINT;
ALTER TABLE SYNCHRONIZATION ADD CONSTRAINT FK_ROTATION_ID FOREIGN KEY (ROTATIONGROUP_ID) REFERENCES TABLEROTATIONGROUP(ID);
