CREATE TABLE [${schema}].[role] (
	[id] [bigint] NOT NULL PRIMARY KEY,
	[role_name] [varchar](255) NULL
)

CREATE TABLE [${schema}].[permission](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[permission_name] [varchar](255) NULL
)

CREATE TABLE [${schema}].[users](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[active] [bit] NOT NULL,
	[password] [varchar](255) NULL,
	[timezone] [varchar](255) DEFAULT 'Europe/Prague',
	[username] [varchar](255) NULL
)

CREATE TABLE [${schema}].[role_permission](
	[role_id] [bigint] NOT NULL,
	[permission_id] [bigint] NOT NULL
) ON [PRIMARY]

CREATE TABLE [${schema}].[user_role](
	[users_id] [bigint] NOT NULL,
	[roles_id] [bigint] NOT NULL
) ON [PRIMARY]

CREATE TABLE [${schema}].[scheduler](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[cronExpression] [varchar](255) NULL,
	[dayOfMonth] [int] NULL,
	[dayOfYear] [int] NULL,
	[daysOfWeek] [int] NULL,
	[hour] [int] NULL,
	[minute] [int] NULL,
	[period] [int] NULL,
	[schedulerDefinitionType] [varchar](255) NULL,
	[second] [int] NULL,
	[startDate] [date] NULL
)

CREATE TABLE [${schema}].[snowTable](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[hasUpdatedOnColumn] [bit] NOT NULL,
	[name] [varchar](255) NULL,
	[prefix] [varchar](255) NULL,
	[sysId] [varchar](255) NULL,
	[userQuery] [varchar](1000) NULL
)

CREATE TABLE [${schema}].[synchronization](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[created] [datetime2](7) NULL,
	[createdBy] [varchar](255) NULL,
	[enabled] [bit] NOT NULL,
	[manual] [bit] NOT NULL,
	[mirrorTableName] [varchar](255) NOT NULL,
	[deletetype] [varchar](255) NOT NULL,
	[name] [varchar](255) NOT NULL,
	[updated] [datetime2](7) NULL,
	[updatedBy] [varchar](255) NULL,
	[waiting] [bit] NOT NULL,
	[scheduler_id] [bigint] NULL,
	[snowTable_id] [bigint] NULL
)
CREATE TABLE [${schema}].[snowColumn](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[length] [int] NULL,
	[name] [varchar](255) NULL,
	[sysId] [varchar](255) NULL,
	[type] [varchar](255) NULL,
	[snowtable_id] [bigint] NULL
)

CREATE TABLE [${schema}].[notification](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[notificationReceiver] [varchar](255) NULL,
	[notificationType] [varchar](255) NULL,
	[synchronization_id] [bigint] NULL
)

CREATE TABLE [${schema}].[activityLog](
	[id] [bigint] NOT NULL PRIMARY KEY,
	[deletedCount] [int] NULL,
	[endDate] [datetime2](7) NULL,
	[insertedCount] [int] NULL,
	[logs] [varchar](max) NULL,
	[startDate] [datetime2](7) NULL,
	[startedBy] [varchar](255) NULL,
	[status] [varchar](255) NULL,
	[totalToDelete] [int] NULL,
	[totalToInsert] [int] NULL,
	[totalToUpdate] [int] NULL,
	[type] [varchar](255) NULL,
	[updatedCount] [int] NULL,
	[synchronization] [bigint] NULL
)

CREATE TABLE [${schema}].[SEQUENCE_TABLE_GENERATOR](
	[SEQ_TABLE_NAME] [varchar](255) NULL,
	[SEQ_NEXT_VALUE] [int] NULL
) ON [PRIMARY]

ALTER TABLE [${schema}].[role_permission]  WITH CHECK ADD  CONSTRAINT [FKBD40D5385E18A62B] FOREIGN KEY([permission_id])
REFERENCES [${schema}].[permission] ([id]);

ALTER TABLE [${schema}].[role_permission]  WITH CHECK ADD  CONSTRAINT [FKBD40D53860B59A0B] FOREIGN KEY([role_id])
REFERENCES [${schema}].[role] ([id]);

ALTER TABLE [${schema}].[activityLog]  WITH CHECK ADD  CONSTRAINT [FKC95329B59398B953] FOREIGN KEY([synchronization])
REFERENCES [${schema}].[synchronization] ([id]);

ALTER TABLE [${schema}].[notification]  WITH CHECK ADD  CONSTRAINT [FK237A88EB8FF4AA4D] FOREIGN KEY([synchronization_id])
REFERENCES [${schema}].[synchronization] ([id]);

ALTER TABLE [${schema}].[snowColumn]  WITH CHECK ADD  CONSTRAINT [FK8CB142B9CF389574] FOREIGN KEY([snowtable_id])
REFERENCES [${schema}].[snowTable] ([id]);

ALTER TABLE [${schema}].[synchronization]  WITH CHECK ADD  CONSTRAINT [FK4F99F26092C0842D] FOREIGN KEY([scheduler_id])
REFERENCES [${schema}].[scheduler] ([id]);

ALTER TABLE [${schema}].[synchronization]  WITH CHECK ADD  CONSTRAINT [FK4F99F260CF389574] FOREIGN KEY([snowTable_id])
REFERENCES [${schema}].[snowTable] ([id]);

ALTER TABLE [${schema}].[user_role]  WITH CHECK ADD  CONSTRAINT [FK143BF46A546A2CE] FOREIGN KEY([users_id])
REFERENCES [${schema}].[users] ([id]);

ALTER TABLE [${schema}].[user_role]  WITH CHECK ADD  CONSTRAINT [FK143BF46AFECE1264] FOREIGN KEY([roles_id])
REFERENCES [${schema}].[role] ([id]);