ALTER TABLE `scheduler` ADD COLUMN `schedulerType` VARCHAR(40) DEFAULT 'incrementalLoad';

ALTER TABLE `synchronization` DROP FOREIGN KEY `FK4F99F26092C0842D`;
ALTER TABLE `synchronization` CHANGE COLUMN `scheduler_id` `inc_scheduler_id` bigint;
ALTER TABLE `synchronization` ADD CONSTRAINT `fk_incremental_load_scheduler` FOREIGN KEY (`inc_scheduler_id`) REFERENCES `scheduler` (`id`);

ALTER TABLE `synchronization` ADD COLUMN `full_scheduler_id` bigint DEFAULT NULL;

ALTER TABLE `synchronization`
    ADD CONSTRAINT `fk_full_load_scheduler`
    FOREIGN KEY (`full_scheduler_id`)
    REFERENCES `scheduler` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION;

    
DROP VIEW IF EXISTS synchronizationView;

CREATE VIEW synchronizationView AS
SELECT sync.id,
    sync.manual,
    sync.waiting,
    sync.enabled,
    sync.name,
    qrtz_incremental.next_fire_time,
    IF (incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME) as nextIncrementalStartLong,
    IF (fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1', NULL, qrtz_full.NEXT_FIRE_TIME) as nextFullStartLong,
    IF (
        IF (incrementalScheduler.schedulerDefinitionType = 'MANUALLY', NULL, qrtz_incremental.NEXT_FIRE_TIME) is null 
        OR
        IF (fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1', NULL, qrtz_full.NEXT_FIRE_TIME) is null,
        COALESCE (
            IF (incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME)
            , IF (fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1', NULL, qrtz_full.NEXT_FIRE_TIME)
        ),
        LEAST (
            IF (incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME),
            IF (fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1', NULL, qrtz_full.NEXT_FIRE_TIME)
        )
    ) as nextStartLong,
    a.id AS lastLog_id,
    TIMESTAMPDIFF(SECOND, a.startDate, a.endDate) * 1000 AS lastDuration
FROM synchronization sync 
    JOIN scheduler incrementalScheduler ON sync.inc_scheduler_id = incrementalScheduler.id
    LEFT JOIN scheduler fullScheduler ON sync.full_scheduler_id = fullScheduler.id
    LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON CONCAT('SyncId_', sync.id) = qrtz_incremental.TRIGGER_NAME
    LEFT JOIN activityLog a ON  a.id = (SELECT al.id FROM activityLog al WHERE al.synchronization = sync.id ORDER BY al.id DESC LIMIT 1)
    LEFT JOIN QRTZ_TRIGGERS qrtz_full ON CONCAT('CleanAndSync_SyncId_', sync.id) = qrtz_full.TRIGGER_NAME;
