ALTER TABLE "SCHEDULER" ADD "SCHEDULERTYPE" VARCHAR2(40 CHAR) DEFAULT 'incrementalLoad';

ALTER TABLE "SYNCHRONIZATION" RENAME COLUMN "SCHEDULER_ID" TO "INC_SCHEDULER_ID";

ALTER TABLE "SYNCHRONIZATION" ADD "FULL_SCHEDULER_ID" NUMBER(19,0) DEFAULT NULL;

ALTER TABLE "SYNCHRONIZATION"
    ADD CONSTRAINT "FK_FULL_LOAD_SCHEDULER" 
    FOREIGN KEY ("FULL_SCHEDULER_ID")
    REFERENCES "SCHEDULER" ("ID");


CREATE OR REPLACE VIEW synchronizationView AS
SELECT sync.id,
    sync.manual,
    sync.waiting,
    sync.enabled,
    sync.name,
    (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) AS nextIncrementalStartLong,
    (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) AS nextFullStartLong,
    (CASE
      WHEN
        (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) is null
        OR
        (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END) is null
      THEN
        COALESCE(
          (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END),
          (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
        )
      ELSE
        LEAST(
          (CASE WHEN incrementalScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END),
          (CASE WHEN fullScheduler.schedulerDefinitionType = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = -1 THEN null ELSE qrtz_full.NEXT_FIRE_TIME END)
        )
      END
    ) as nextStartLong, 
    a.id AS lastLog_id,
    (CAST(a.endDate AS DATE) - CAST(a.startDate AS DATE)) * 24 * 60 * 60 * 1000 AS lastDuration
FROM synchronization sync
    JOIN scheduler incrementalScheduler ON sync.inc_scheduler_id = incrementalScheduler.id
    LEFT JOIN scheduler fullScheduler ON sync.full_scheduler_id = fullScheduler.id
    LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON 'SyncId_' || sync.id = qrtz_incremental.TRIGGER_NAME
    LEFT JOIN ( SELECT startDate,
                    endDate,
                    synchronization,
                    id
                FROM activityLog
                WHERE id IN (SELECT MAX(id) FROM activitylog GROUP BY synchronization)) a
        ON sync.id = a.synchronization
    LEFT JOIN QRTZ_TRIGGERS qrtz_full ON 'CleanAndSync_SyncId_' || sync.id = qrtz_full.TRIGGER_NAME
;

commit;
