--
-- PostgreSQL database dump
--

-- Dumped from database version 9.2.3
-- Dumped by pg_dump version 9.2.3
-- Started on 2013-11-15 14:45:25

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET default_with_oids = false;

--
-- TOC entry 180 (class 1259 OID 28462)
-- Name: activitylog; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".activitylog (
    id bigint NOT NULL,
    deletedcount integer,
    enddate timestamp without time zone,
    insertedcount integer,
    logs text,
    startdate timestamp without time zone,
    startedby character varying(255),
    status character varying(255),
    totaltodelete integer,
    totaltoinsert integer,
    totaltoupdate integer,
    type character varying(255),
    updatedcount integer,
    synchronization bigint
);


--
-- TOC entry 181 (class 1259 OID 28470)
-- Name: notification; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".notification (
    id bigint NOT NULL,
    notificationreceiver character varying(255),
    notificationtype character varying(255),
    synchronization_id bigint
);


--
-- TOC entry 182 (class 1259 OID 28478)
-- Name: permission; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".permission (
    id bigint NOT NULL,
    permission_name character varying(255)
);


--
-- TOC entry 183 (class 1259 OID 28483)
-- Name: role; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".role (
    id bigint NOT NULL,
    role_name character varying(255)
);


--
-- TOC entry 184 (class 1259 OID 28488)
-- Name: role_permission; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".role_permission (
    role_id bigint NOT NULL,
    permission_id bigint NOT NULL
);


--
-- TOC entry 185 (class 1259 OID 28491)
-- Name: scheduler; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".scheduler (
    id bigint NOT NULL,
    cronexpression character varying(255),
    dayofmonth integer,
    dayofyear integer,
    daysofweek integer,
    hour integer,
    minute integer,
    period integer,
    schedulerdefinitiontype character varying(255),
    second integer,
    startdate timestamp without time zone
);


--
-- TOC entry 192 (class 1259 OID 28595)
-- Name: sequence_table_generator; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".sequence_table_generator (
    seq_table_name character varying(255),
    seq_next_value integer
);


--
-- TOC entry 186 (class 1259 OID 28499)
-- Name: snowcolumn; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".snowcolumn (
    id bigint NOT NULL,
    length integer,
    name character varying(255),
    sysid character varying(255),
    type character varying(255),
    snowtable_id bigint
);


--
-- TOC entry 187 (class 1259 OID 28507)
-- Name: snowtable; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".snowtable (
    id bigint NOT NULL,
    name character varying(255),
    prefix character varying(255),
    sysid character varying(255),
    userquery character varying(1000),
    hasUpdatedOnColumn boolean DEFAULT NULL
);


--
-- TOC entry 188 (class 1259 OID 28515)
-- Name: synchronization; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".synchronization (
    id bigint NOT NULL,
    created timestamp without time zone,
    createdby character varying(255),
    enabled boolean NOT NULL,
    manual boolean NOT NULL,
    mirrortablename character varying(255) NOT NULL,
    deletetype character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    updated timestamp without time zone,
    updatedby character varying(255),
    waiting boolean NOT NULL,
    scheduler_id bigint,
    snowtable_id bigint
);


--
-- TOC entry 189 (class 1259 OID 28523)
-- Name: synchronizationview; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".synchronizationview (
    id bigint NOT NULL,
    enabled boolean NOT NULL,
    lastduration bigint,
    manual boolean NOT NULL,
    name character varying(255),
    nextstart timestamp without time zone,
    waiting boolean NOT NULL,
    lastlog_id bigint
);


--
-- TOC entry 190 (class 1259 OID 28528)
-- Name: user_role; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".user_role (
    users_id bigint NOT NULL,
    roles_id bigint NOT NULL
);


--
-- TOC entry 191 (class 1259 OID 28531)
-- Name: users; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE "${schema}".users (
    id bigint NOT NULL,
    active boolean NOT NULL,
    password character varying(255),
    username character varying(255),
    timezone character varying(255) DEFAULT 'Europe/Prague'
);


--
-- TOC entry 2008 (class 2606 OID 28469)
-- Name: activitylog_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".activitylog
    ADD CONSTRAINT activitylog_pkey PRIMARY KEY (id);


--
-- TOC entry 2022 (class 2606 OID 28565)
-- Name: mirrortablename_; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".synchronization
    ADD CONSTRAINT mirrortablename_ UNIQUE (mirrortablename);


--
-- TOC entry 2024 (class 2606 OID 28567)
-- Name: name_; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".synchronization
    ADD CONSTRAINT name_ UNIQUE (name);


--
-- TOC entry 2010 (class 2606 OID 28477)
-- Name: notification_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".notification
    ADD CONSTRAINT notification_pkey PRIMARY KEY (id);


--
-- TOC entry 2012 (class 2606 OID 28482)
-- Name: permission_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".permission
    ADD CONSTRAINT permission_pkey PRIMARY KEY (id);


--
-- TOC entry 2014 (class 2606 OID 28487)
-- Name: role_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".role
    ADD CONSTRAINT role_pkey PRIMARY KEY (id);


--
-- TOC entry 2016 (class 2606 OID 28498)
-- Name: scheduler_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".scheduler
    ADD CONSTRAINT scheduler_pkey PRIMARY KEY (id);




--
-- TOC entry 2018 (class 2606 OID 28506)
-- Name: snowcolumn_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".snowcolumn
    ADD CONSTRAINT snowcolumn_pkey PRIMARY KEY (id);


--
-- TOC entry 2020 (class 2606 OID 28514)
-- Name: snowtable_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".snowtable
    ADD CONSTRAINT snowtable_pkey PRIMARY KEY (id);


--
-- TOC entry 2026 (class 2606 OID 28522)
-- Name: synchronization_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".synchronization
    ADD CONSTRAINT synchronization_pkey PRIMARY KEY (id);


--
-- TOC entry 2028 (class 2606 OID 28527)
-- Name: synchronizationview_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".synchronizationview
    ADD CONSTRAINT synchronizationview_pkey PRIMARY KEY (id);


--
-- TOC entry 2030 (class 2606 OID 28594)
-- Name: username_; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".users
    ADD CONSTRAINT username_ UNIQUE (username);


--
-- TOC entry 2032 (class 2606 OID 28538)
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);



--
-- TOC entry 2042 (class 2606 OID 28588)
-- Name: fk143bf46a546a2ce; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".user_role
    ADD CONSTRAINT fk143bf46a546a2ce FOREIGN KEY (users_id) REFERENCES users(id);


--
-- TOC entry 2041 (class 2606 OID 28583)
-- Name: fk143bf46afece1264; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".user_role
    ADD CONSTRAINT fk143bf46afece1264 FOREIGN KEY (roles_id) REFERENCES role(id);


--
-- TOC entry 2034 (class 2606 OID 28544)
-- Name: fk237a88eb8ff4aa4d; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".notification
    ADD CONSTRAINT fk237a88eb8ff4aa4d FOREIGN KEY (synchronization_id) REFERENCES synchronization(id);


--
-- TOC entry 2040 (class 2606 OID 28578)
-- Name: fk32c271255f08afc7; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".synchronizationview
    ADD CONSTRAINT fk32c271255f08afc7 FOREIGN KEY (lastlog_id) REFERENCES activitylog(id);


--
-- TOC entry 2038 (class 2606 OID 28568)
-- Name: fk4f99f26092c0842d; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".synchronization
    ADD CONSTRAINT fk4f99f26092c0842d FOREIGN KEY (scheduler_id) REFERENCES scheduler(id);


--
-- TOC entry 2039 (class 2606 OID 28573)
-- Name: fk4f99f260cf389574; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".synchronization
    ADD CONSTRAINT fk4f99f260cf389574 FOREIGN KEY (snowtable_id) REFERENCES snowtable(id);


--
-- TOC entry 2037 (class 2606 OID 28559)
-- Name: fk8cb142b9cf389574; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".snowcolumn
    ADD CONSTRAINT fk8cb142b9cf389574 FOREIGN KEY (snowtable_id) REFERENCES snowtable(id);


--
-- TOC entry 2035 (class 2606 OID 28549)
-- Name: fkbd40d5385e18a62b; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".role_permission
    ADD CONSTRAINT fkbd40d5385e18a62b FOREIGN KEY (permission_id) REFERENCES permission(id);


--
-- TOC entry 2036 (class 2606 OID 28554)
-- Name: fkbd40d53860b59a0b; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".role_permission
    ADD CONSTRAINT fkbd40d53860b59a0b FOREIGN KEY (role_id) REFERENCES role(id);


--
-- TOC entry 2033 (class 2606 OID 28539)
-- Name: fkc95329b59398b953; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY "${schema}".activitylog
    ADD CONSTRAINT fkc95329b59398b953 FOREIGN KEY (synchronization) REFERENCES synchronization(id);


-- Completed on 2013-11-15 14:45:25

--
-- PostgreSQL database dump complete
--
 