DROP VIEW IF EXISTS "${schema}".synchronizationView;
CREATE VIEW "${schema}".synchronizationView AS
  SELECT
        sync.id
      , sync.manual
      , COALESCE((qrtz.NEXT_FIRE_TIME < ((EXTRACT(EPOCH FROM NOW()) * 1000) + 1000)), false) as waiting
      , (CASE WHEN qrtzFired.minFiredTime IS NOT NULL THEN true ELSE false END) as running
      , qrtzFired.minFiredTime as runningSinceLong
      , sync.enabled
      , sync.name
      , sync.mirrortablename
      , sync.deletetype
      , sync.snowtable_id
      , sync.created
      , sync.createdby
      , sync.updated
      , sync.updatedby
      , sync.includeinheritedcolumns
      , sync.autoSchemaUpdate
      , sync.referencefieldtype
      , sync.schedulerPriority
      , (CASE WHEN incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1' THEN null ELSE qrtz_incremental.NEXT_FIRE_TIME END) as nextIncrementalStartLong
      , minNextFullStart.nextFullStartLong as nextFullStartLong
      , qrtz.NEXT_FIRE_TIME as nextStartLong
      , a.id AS lastLog_id
      , a.startDate AS lastStartDate
      , a.status AS lastStatus
      , a.insertedcount AS lastInsertedCount
      , a.updatedcount AS lastUpdatedCount
      , a.deletedcount AS lastDeletedCount
      , a.insertedcount + a.updatedcount + a.deletedcount AS lastTotal
      , EXTRACT(EPOCH FROM (a.endDate - a.startDate)) * 1000 AS lastDuration
      , st.type AS snowtableType
      , st.userquery AS snowtableUserquery
      , incrementalScheduler.schedulerdefinitiontype AS incSchedulerDefinitionType
  FROM "${schema}".synchronization AS sync
         JOIN "${schema}".snowTable st                        ON sync.snowtable_id = st.id
         JOIN "${schema}".scheduler incrementalScheduler      ON sync.inc_scheduler_id = incrementalScheduler.id
         LEFT JOIN "${schema}".QRTZ_TRIGGERS qrtz_incremental ON qrtz_incremental.SCHED_NAME = 'org.springframework.scheduling.quartz.SchedulerFactoryBean#0' and qrtz_incremental.TRIGGER_NAME = CONCAT('SyncId_', CONCAT(sync.id, '_IncrementalLoad')) and qrtz_incremental.TRIGGER_GROUP = 'DEFAULT'
         LEFT JOIN "${schema}".minNextFullStartView minNextFullStart ON sync.id = minNextFullStart.sync_id
         LEFT JOIN "${schema}".activityLog a                  ON sync.lastLog_id = a.id
         LEFT JOIN "${schema}".minFireTimeView qrtz           ON      qrtz.JOB_NAME = CONCAT('SyncId_', sync.id)
         LEFT JOIN "${schema}".minFiredTimeView qrtzFired     ON qrtzFired.JOB_NAME = CONCAT('SyncId_', sync.id)
