@echo off
rem
rem This script silently uninstalls SnowMirror. It removes Windows service (if installed)
rem and deletes all SnowMirror files and directories. It does not delete configuration and mirror databases.
rem
rem Exit codes:
rem 0 - success
rem 1 - un-installation did not start: missing confirmation
rem 2 - un-installation did not start: missing Uninstall.exe file
rem
SET confirmation=%1

rem "Internal = the script copied itself into tmp folder and now is executed from the temporary folder"
IF "%confirmation%" == "Internal" goto uninstall

echo %confirmation%

IF /I NOT "%confirmation%" == "I_Agree" (
  echo "ERROR 1 - un-installation did not start: missing confirmation"
  echo "You have to confirm that you want to uninstall SnowMirror. You do that by passing the following parameter: I_Agree"
  echo "If you agree, the script will remove Windows service (if installed) and delete all SnowMirror files and directories."
  echo "It will not delete configuration and mirror databases."
  echo "An example how to call this script:
  echo "uninstall.bat I_Agree"
  exit /B 1
)

SET sm_dir=%~dp0
echo "SnowMirror Uninstaller: started."
IF %confirmation% == "internal" goto uninstall

SET "tmp_script=%temp%\snowMirror-uninstall%RANDOM%.bat"
echo "SnowMirror Uninstaller: copying uninstall script to %tmp_script%"
copy "%sm_dir%uninstall.bat" "%tmp_script%"
echo "SnowMirror Uninstaller: executing %tmp_script%"
Call %tmp_script% Internal & rmdir /s /q "%sm_dir%" & (goto) 2>nul & cmd /c exit /B "^!errorlevel^!"
GOTO eof

:uninstall

IF EXIST "%sm_dir%Uninstall.exe" GOTO uninstallerExists
echo "SnowMirror Uninstaller: %sm_dir%Uninstall.exe not found!"
exit /B 2
goto eof
:uninstallerExists

IF NOT "%cd%\" == "%sm_dir%" goto dirOk
  cd..
  echo "SnowMirror Uninstaller: Set current directory to %cd%"
:dirOk

echo "SnowMirror Uninstaller: uninstalling from %sm_dir%"
start /wait /D "%sm_dir%" Uninstall.exe /S _?=%sm_dir%
SET err_code=%errorlevel%
echo "SnowMirror Uninstaller: return code is %err_code%"

IF "%err_code%" == "0" goto uninstalled
echo "SnowMirror Uninstaller: failed - %err_code%"
exit /B 3

:uninstalled
echo "SnowMirror Uninstaller: uninstalled."
echo "SnowMirror Uninstaller: deleting %sm_dir%Uninstall.exe"
del "%sm_dir%Uninstall.exe"
echo "SnowMirror Uninstaller: deleting %sm_dir%"
echo "SnowMirror Uninstaller: deleting %tmp_script%"
echo "SnowMirror Uninstaller: finished."

:eof