/*
 * Decompiled with CFR 0.152.
 */
package com.snowMirror.upgrade;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatBinary {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BINARY_NAME = "tomcat10.exe";
    private final Path rootDir;

    public TomcatBinary(Path rootDir) {
        this.rootDir = rootDir;
    }

    public void deleteAndRetryIfNotAccessible() {
        Path tomcatExe = null;
        try {
            Integer version;
            Iterator<Integer> iterator = List.of(Integer.valueOf(10), Integer.valueOf(9), Integer.valueOf(8), Integer.valueOf(7)).iterator();
            while (iterator.hasNext() && !Files.exists(tomcatExe = this.rootDir.resolve("bin/tomcat" + (version = iterator.next()) + ".exe"), new LinkOption[0])) {
            }
            if (!Files.exists(tomcatExe, new LinkOption[0])) {
                return;
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to delete " + tomcatExe, e);
            return;
        }
        this.logger.info("Deleting {}", (Object)tomcatExe);
        for (int i = 0; i < 60; ++i) {
            try {
                Files.delete(tomcatExe);
                this.logger.info("Deleted {}", (Object)tomcatExe);
                break;
            }
            catch (Exception e) {
                this.logger.warn("Failed to delete " + tomcatExe + ". Attempt " + i, e);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e2) {
                    this.logger.warn("Failed to sleep.", e2);
                }
                continue;
            }
        }
        this.logger.info("Finished.");
    }
}

