/*
 * Decompiled with CFR 0.152.
 */
package com.snowMirror.upgrade;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXml {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Path path;

    public WebXml(Path path) {
        this.path = path;
    }

    public void upgrade() {
        try {
            this.logger.info("Updating conf/web.xml");
            String content = Files.readString(this.path, StandardCharsets.UTF_8);
            String newContent = this.updateHeader(content);
            newContent = this.updateWebAppElement(newContent);
            if (!Objects.equals(content, newContent)) {
                Files.writeString(this.path, (CharSequence)newContent, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            this.logger.info("Finished updating conf/web.xml");
        }
        catch (Exception e) {
            System.out.println("Failed to upgrade server.xml");
            e.printStackTrace();
        }
    }

    public String updateHeader(String content) {
        this.logger.info("Updating header.");
        String oldHeader = "<\\?xml version=\"1\\.0\" encoding=\"ISO-8859-1\"\\?>";
        String newHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String newContent = content.replaceFirst(oldHeader, newHeader);
        if (Objects.equals(content, newContent)) {
            this.logger.info("Finished. Nothing to do - header already up-to-date.");
        } else {
            this.logger.info("Finished.");
        }
        return newContent;
    }

    public String updateWebAppElement(String content) {
        this.logger.info("Updating web-app element");
        String oldElement = "<web-app[^>]*>";
        String newElement = "<web-app xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\n xsi:schemaLocation=\"http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd\"\n version=\"3.1\">";
        String newContent = content.replaceFirst(oldElement, newElement);
        if (Objects.equals(content, newContent)) {
            this.logger.info("Finished. Nothing to do - element already up-to-date.");
        } else {
            this.logger.info("Finished.");
        }
        return newContent;
    }
}

