ALTER TABLE SCHEDULER ADD COLUMN SCHEDULERTYPE VARCHAR(40) DEFAULT 'incrementalLoad';

ALTER TABLE SYNCHRONIZATION ALTER SCHEDULER_ID RENAME TO INC_SCHEDULER_ID;

ALTER TABLE SYNCHRONIZATION ADD COLUMN FULL_SCHEDULER_ID BIGINT DEFAULT NULL;

ALTER TABLE SYNCHRONIZATION
    ADD FOREIGN KEY (FULL_SCHEDULER_ID)
    REFERENCES SCHEDULER (ID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION;
    


DROP VIEW IF EXISTS synchronizationView;    

CREATE VIEW synchronizationView AS
SELECT sync.id,
    sync.manual,
    sync.waiting,
    sync.enabled,
    sync.name,
    CASEWHEN (incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME) as nextIncrementalStartLong,
    CASEWHEN (fullScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1', NULL, qrtz_full.NEXT_FIRE_TIME) as nextFullStartLong,
    LEAST(
        CASEWHEN (incrementalScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_incremental.NEXT_FIRE_TIME = '-1', NULL, qrtz_incremental.NEXT_FIRE_TIME),
        CASEWHEN (fullScheduler.SCHEDULERDEFINITIONTYPE = 'MANUALLY' or qrtz_full.NEXT_FIRE_TIME = '-1', NULL, qrtz_full.NEXT_FIRE_TIME)
    ) as nextStartLong,
    a.id AS lastLog_id,
    TIMESTAMPDIFF(SECOND, a.startDate, a.endDate) * 1000 AS lastDuration
FROM SYNCHRONIZATION AS sync
    JOIN SCHEDULER incrementalScheduler ON sync.INC_SCHEDULER_ID = incrementalScheduler.ID
    LEFT JOIN SCHEDULER fullScheduler ON sync.FULL_SCHEDULER_ID = fullScheduler.ID
    LEFT JOIN QRTZ_TRIGGERS qrtz_incremental ON CONCAT('SyncId_', sync.ID) = qrtz_incremental.TRIGGER_NAME
    LEFT JOIN (select * from ACTIVITYLOG act where act.id in (select max(al.ID) as maxid from ACTIVITYLOG al group by al.SYNCHRONIZATION)) AS a ON sync.ID = a.SYNCHRONIZATION
    LEFT JOIN QRTZ_TRIGGERS qrtz_full ON CONCAT('CleanAndSync_SyncId_', sync.id) = qrtz_full.TRIGGER_NAME;

commit;

