CREATE TABLE [${schema}].[choiceValue](
    [id] [bigint] NOT NULL PRIMARY KEY,
    [choiceValue] [varchar](255) NULL,
    [label] [varchar](255) NULL,
    [sequence] [int] NULL,
    [column_id] bigint NOT NULL,
    CONSTRAINT [fk_choiceValue_column]
        FOREIGN KEY ([column_id])
            REFERENCES [${schema}].[snowColumn] ([id])
            ON DELETE CASCADE
);

ALTER TABLE [${schema}].[snowColumn] ADD [columnLabel] [varchar](255) DEFAULT NULL;
ALTER TABLE [${schema}].[snowColumn] ADD [reference] [varchar](255) DEFAULT NULL;
ALTER TABLE [${schema}].[snowColumn] ADD [choice] [int] DEFAULT NULL;
ALTER TABLE [${schema}].[snowColumn] ADD [isFormTitleColumn] [bit] DEFAULT 0 NOT NULL;
ALTER TABLE [${schema}].[snowColumn] ADD [dvType] [varchar](255) DEFAULT NULL;
ALTER TABLE [${schema}].[snowColumn] ADD [dvLength] [int] DEFAULT NULL;
ALTER TABLE [${schema}].[snowColumn] ADD [dvIsArrayType] [bit] DEFAULT NULL;

CREATE TABLE [${schema}].[formElement](
    [id] [bigint] NOT NULL PRIMARY KEY,
    [columnName] [varchar](255) NULL,
    [position] [int] NULL,
    [internalType] [varchar](255) NULL,
    [maxLength] [int] NULL,
    [type] [varchar](20) NOT NULL,
    [createdAt] DATETIME NOT NULL DEFAULT GETDATE(),
    [synchronization_id] BIGINT NOT NULL,
    CONSTRAINT FK_formElement_synchronization
        FOREIGN KEY (synchronization_id)
        REFERENCES [${schema}].[synchronization](id)
        ON DELETE CASCADE
);
