CREATE TABLE asyncNotification (
  `id` bigint NOT NULL,
  `asyncName` varchar(190) NOT NULL,
  `subName` varchar(255) default NULL,
  `description` text default NULL,
  `status` varchar(100) NOT NULL,
  `totalCount` int NOT NULL default 0,
  `totalDone` int NOT NULL default 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY(`asyncName`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE asyncNotificationMessage (
  `id` bigint NOT NULL,
  `notificationId` bigint NOT NULL,
  `type` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `createTime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_asyncNotificationMessage_notificationId` FOREIGN KEY(`notificationId`) REFERENCES `asyncNotification` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;
