CREATE TABLE `mirrorTable` (
  `id` bigint NOT NULL,
  `tmp_id` bigint auto_increment,
  `name` varchar(255) NOT NULL,
  `tmpName` varchar(255),
  `shardScheduleSysId` varchar(32),
  `sync_id` bigint NOT NULL,
  PRIMARY KEY (`tmp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `tableRotationGroup` (
  `id` bigint NOT NULL,
  `rotationType` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

CREATE TABLE `tableRotationSchedule` (
  `id` bigint NOT NULL,
  `sysId` varchar(32) NOT NULL,
  `tableName` varchar(255) NOT NULL,
  `validFrom` datetime,
  `validTo` datetime,
  `isoffline` tinyint DEFAULT 0 NOT NULL,
  `rotationGroup_id` bigint NOT NULL,
  PRIMARY KEY (ID),
  CONSTRAINT `fk_trs_rotationgroup_id` FOREIGN KEY (`rotationGroup_id`) REFERENCES `tableRotationGroup` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;

INSERT INTO `mirrorTable`(`id`, `name`, `tmpName`, `sync_id`) (
  SELECT -1, s.`mirrorTableName` name, s.`tmpMirrorTableName` tmpName, s.`id` sync_id
  FROM `synchronization` s
  WHERE s.`mirrorTableName` IS NOT NULL
);

INSERT INTO `SEQUENCE_TABLE_GENERATOR`(`SEQ_TABLE_NAME`, `SEQ_NEXT_VALUE`) VALUES ('MIRROR_TABLE', (SELECT COALESCE(MAX(`tmp_id`), 0) + 1 FROM `mirrorTable`));

UPDATE `mirrorTable` SET `id` = `tmp_id`;
ALTER TABLE `mirrorTable` DROP COLUMN `tmp_id`;
ALTER TABLE `mirrorTable` ADD PRIMARY KEY(`id`);
ALTER TABLE `mirrorTable` ADD CONSTRAINT `fk_mirr_tbl_sync_id` FOREIGN KEY (`sync_id`) REFERENCES `synchronization` (`id`);

ALTER TABLE `synchronization` ADD COLUMN `rotation` varchar(20) DEFAULT 'DISABLED' NOT NULL;
ALTER TABLE `synchronization` ADD COLUMN `rotationGroup_id` bigint;
ALTER TABLE `synchronization` ADD CONSTRAINT `fk_rotation_id` FOREIGN KEY (`rotationGroup_id`) REFERENCES `tableRotationGroup` (`id`);
