-- Add new permissions
INSERT INTO "PERMISSION" (id, "PERMISSION_NAME")
VALUES ((SELECT SEQ_NEXT_VALUE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC');

INSERT INTO "PERMISSION" (id, "PERMISSION_NAME")
VALUES ((SELECT SEQ_NEXT_VALUE + 1 FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL');

INSERT INTO "PERMISSION" (id, "PERMISSION_NAME")
VALUES ((SELECT SEQ_NEXT_VALUE + 2 FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF');

INSERT INTO "PERMISSION" (id, "PERMISSION_NAME")
VALUES ((SELECT SEQ_NEXT_VALUE + 3 FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM');

UPDATE SEQUENCE_TABLE_GENERATOR
SET SEQ_NEXT_VALUE = SEQ_NEXT_VALUE + 4
WHERE SEQ_TABLE_NAME = 'PERMISSION';

DELETE
FROM "ROLE_PERMISSION"
WHERE "PERMISSION_ID" =
      (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE');

DELETE
FROM "PERMISSION"
WHERE "PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE';


INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id
         FROM "PERMISSION" p
         WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM'));


INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id
         FROM "PERMISSION" p
         WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM'));


INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id
         FROM "PERMISSION" p
         WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_CLEAN_AND_SYNC'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_INCREMENTAL'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_DIFF'));
INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id FROM "PERMISSION" p WHERE p."PERMISSION_NAME" = 'PERMISSION_SYNCHRONIZATION_EXECUTE_SYNC_FROM'));