/*
 * Copyright (c) 2025 GuideVision, s.r.o.
 */

INSERT INTO "ROLE" (id, "ROLE_NAME")
VALUES ((SELECT SEQ_NEXT_VALUE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'ROLE'),
        'DATA_VIEWER');

UPDATE SEQUENCE_TABLE_GENERATOR
SET SEQ_NEXT_VALUE = SEQ_NEXT_VALUE + 1
WHERE SEQ_TABLE_NAME = 'ROLE';

INSERT INTO "PERMISSION" (id, "PERMISSION_NAME")
VALUES ((SELECT SEQ_NEXT_VALUE FROM SEQUENCE_TABLE_GENERATOR WHERE SEQ_TABLE_NAME = 'PERMISSION'),
        'PERMISSION_DATA_VIEWER');

UPDATE SEQUENCE_TABLE_GENERATOR
SET SEQ_NEXT_VALUE = SEQ_NEXT_VALUE + 1
WHERE SEQ_TABLE_NAME = 'PERMISSION';

INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SUPER_ADMINISTRATOR'),
        (SELECT p.id
         FROM "PERMISSION" p
         WHERE p."PERMISSION_NAME" = 'PERMISSION_DATA_VIEWER'));

INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_ADMINISTRATOR'),
        (SELECT p.id
         FROM "PERMISSION" p
         WHERE p."PERMISSION_NAME" = 'PERMISSION_DATA_VIEWER'));

INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'SYNCHRONIZATION_SUPERVISOR'),
        (SELECT p.id
         FROM "PERMISSION" p
         WHERE p."PERMISSION_NAME" = 'PERMISSION_DATA_VIEWER'));

INSERT INTO "ROLE_PERMISSION"("ROLE_ID", "PERMISSION_ID")
VALUES ((SELECT r.id FROM role r WHERE "ROLE_NAME" = 'DATA_VIEWER'),
        (SELECT p.id
         FROM "PERMISSION" p
         WHERE p."PERMISSION_NAME" = 'PERMISSION_DATA_VIEWER'));